/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.Collections;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.geoapi.filter.Name;
import org.apache.sis.internal.geoapi.filter.ValueReference;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.opengis.util.ScopedName;

abstract class PropertyValue<V>
extends LeafExpression<AbstractFeature, V>
implements ValueReference<AbstractFeature, V> {
    private static final long serialVersionUID = 3756361632664536269L;
    protected final String name;

    protected PropertyValue(String string) {
        ArgumentChecks.ensureNonNull("name", string);
        this.name = string;
    }

    @Override
    public final ScopedName getFunctionName() {
        return Name.VALUE_REFERENCE;
    }

    static <V> PropertyValue<V> create(String string, Class<V> clazz) {
        ArgumentChecks.ensureNonNull("type", clazz);
        if (clazz == Object.class) {
            return new AsObject(string);
        }
        return new Converted<V>(clazz, string);
    }

    @Override
    protected final Collection<?> getChildren() {
        return Collections.singleton(this.name);
    }

    @Override
    public final String getXPath() {
        return this.name;
    }

    protected Class<?> getSourceClass() {
        return Object.class;
    }

    @Override
    public final <N> Expression<AbstractFeature, N> toValueType(Class<N> clazz) {
        if (clazz.isAssignableFrom(this.getValueClass())) {
            return this;
        }
        Class<?> clazz2 = this.getSourceClass();
        if (clazz2 != Object.class) {
            return new CastedAndConverted(clazz2, clazz, this.name);
        }
        return PropertyValue.create(this.name, clazz);
    }

    @Override
    public PropertyTypeBuilder expectedType(DefaultFeatureType defaultFeatureType, FeatureTypeBuilder featureTypeBuilder) {
        AbstractIdentifiedType abstractIdentifiedType = defaultFeatureType.getProperty(this.name);
        while (abstractIdentifiedType instanceof AbstractOperation) {
            AbstractIdentifiedType abstractIdentifiedType2 = ((AbstractOperation)abstractIdentifiedType).getResult();
            if (abstractIdentifiedType2 != abstractIdentifiedType) {
                abstractIdentifiedType = abstractIdentifiedType2;
                continue;
            }
            if (abstractIdentifiedType2 instanceof DefaultFeatureType) {
                return featureTypeBuilder.addAssociation((DefaultFeatureType)abstractIdentifiedType2).setName((CharSequence)this.name);
            }
            return null;
        }
        return featureTypeBuilder.addProperty(abstractIdentifiedType);
    }

    private static final class AsObject
    extends PropertyValue<Object> {
        private static final long serialVersionUID = 2854731969723006038L;

        AsObject(String string) {
            super(string);
        }

        @Override
        public Object apply(AbstractFeature abstractFeature) {
            if (abstractFeature != null) {
                try {
                    return abstractFeature.getPropertyValue(this.name);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.warning(illegalArgumentException, true);
                }
            }
            return null;
        }
    }

    private static class Converted<V>
    extends PropertyValue<V>
    implements Optimization.OnExpression<AbstractFeature, V> {
        private static final long serialVersionUID = -1436865010478207066L;
        protected final Class<V> type;

        protected Converted(Class<V> clazz, String string) {
            super(string);
            this.type = clazz;
        }

        @Override
        public final Class<V> getValueClass() {
            return this.type;
        }

        @Override
        public V apply(AbstractFeature abstractFeature) {
            if (abstractFeature != null) {
                try {
                    return ObjectConverters.convert(abstractFeature.getPropertyValue(this.name), this.type);
                }
                catch (UnconvertibleObjectException unconvertibleObjectException) {
                    this.warning(unconvertibleObjectException, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.warning(illegalArgumentException, true);
                }
            }
            return null;
        }

        @Override
        public final Expression<AbstractFeature, ? extends V> optimize(Optimization optimization) {
            DefaultFeatureType defaultFeatureType = optimization.getFeatureType();
            if (defaultFeatureType != null) {
                try {
                    Class clazz;
                    AbstractIdentifiedType abstractIdentifiedType = defaultFeatureType.getProperty(this.name);
                    if (abstractIdentifiedType instanceof DefaultAttributeType && (clazz = ((DefaultAttributeType)abstractIdentifiedType).getValueClass()) != null && clazz != Object.class && !clazz.isAssignableFrom(this.getSourceClass())) {
                        return new CastedAndConverted(clazz, this.type, this.name);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.warning(illegalArgumentException, true);
                }
            }
            return this;
        }

        @Override
        public final PropertyTypeBuilder expectedType(DefaultFeatureType defaultFeatureType, FeatureTypeBuilder featureTypeBuilder) {
            AttributeTypeBuilder attributeTypeBuilder;
            PropertyTypeBuilder propertyTypeBuilder = super.expectedType(defaultFeatureType, featureTypeBuilder);
            if (propertyTypeBuilder instanceof AttributeTypeBuilder && !this.type.isAssignableFrom((attributeTypeBuilder = (AttributeTypeBuilder)propertyTypeBuilder).getValueClass())) {
                return attributeTypeBuilder.setValueClass(this.type);
            }
            return propertyTypeBuilder;
        }
    }

    private static final class CastedAndConverted<S, V>
    extends Converted<V> {
        private static final long serialVersionUID = -58453954752151703L;
        private final Class<S> source;
        private final ObjectConverter<? super S, ? extends V> converter;

        CastedAndConverted(Class<S> clazz, Class<V> clazz2, String string) {
            super(clazz2, string);
            this.source = clazz;
            this.converter = ObjectConverters.find(clazz, clazz2);
        }

        @Override
        protected Class<S> getSourceClass() {
            return this.source;
        }

        @Override
        public V apply(AbstractFeature abstractFeature) {
            if (abstractFeature != null) {
                try {
                    return this.converter.apply(this.source.cast(abstractFeature.getPropertyValue(this.name)));
                }
                catch (ClassCastException | UnconvertibleObjectException runtimeException) {
                    this.warning(runtimeException, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.warning(illegalArgumentException, true);
                }
            }
            return null;
        }
    }
}

