/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.xmlgraphics.util.Service;

public class AdvancedMessageFormat {
    static final Pattern COMMA_SEPARATOR_REGEX;
    private static final Map PART_FACTORIES;
    private static final List OBJECT_FORMATTERS;
    private static final Map FUNCTIONS;
    private CompositePart rootPart;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AdvancedMessageFormat(CharSequence pattern) {
        this.parsePattern(pattern);
    }

    private void parsePattern(CharSequence pattern) {
        this.rootPart = new CompositePart(false);
        StringBuffer sb = new StringBuffer();
        this.parseInnerPattern(pattern, this.rootPart, sb, 0);
    }

    private int parseInnerPattern(CharSequence pattern, CompositePart parent, StringBuffer sb, int start) {
        if (!$assertionsDisabled && sb.length() != 0) {
            throw new AssertionError();
        }
        int i = start;
        int len = pattern.length();
        block7: while (i < len) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '{': {
                    if (sb.length() > 0) {
                        parent.addChild(new TextPart(sb.toString()));
                        sb.setLength(0);
                    }
                    ++i;
                    int nesting = 1;
                    while (i < len) {
                        ch = pattern.charAt(i);
                        if (ch == '{') {
                            ++nesting;
                        } else if (ch == '}' && --nesting == 0) {
                            ++i;
                            break;
                        }
                        sb.append(ch);
                        ++i;
                    }
                    parent.addChild(this.parseField(sb.toString()));
                    sb.setLength(0);
                    continue block7;
                }
                case ']': {
                    ++i;
                    break block7;
                }
                case '[': {
                    if (sb.length() > 0) {
                        parent.addChild(new TextPart(sb.toString()));
                        sb.setLength(0);
                    }
                    ++i;
                    CompositePart composite = new CompositePart(true);
                    parent.addChild(composite);
                    i += this.parseInnerPattern(pattern, composite, sb, i);
                    continue block7;
                }
                case '|': {
                    if (sb.length() > 0) {
                        parent.addChild(new TextPart(sb.toString()));
                        sb.setLength(0);
                    }
                    parent.newSection();
                    ++i;
                    continue block7;
                }
                case '\\': {
                    if (i < len - 1) {
                        ch = pattern.charAt(++i);
                    }
                }
                default: {
                    sb.append(ch);
                    ++i;
                    continue block7;
                }
            }
        }
        if (sb.length() > 0) {
            parent.addChild(new TextPart(sb.toString()));
            sb.setLength(0);
        }
        return i - start;
    }

    private Part parseField(String field) {
        String[] parts = COMMA_SEPARATOR_REGEX.split(field, 3);
        String fieldName = parts[0];
        if (parts.length == 1) {
            if (fieldName.startsWith("#")) {
                return new FunctionPart(fieldName.substring(1));
            }
            return new SimpleFieldPart(fieldName);
        }
        String format = parts[1];
        PartFactory factory = (PartFactory)PART_FACTORIES.get(format);
        if (factory == null) {
            throw new IllegalArgumentException("No PartFactory available under the name: " + format);
        }
        if (parts.length == 2) {
            return factory.newPart(fieldName, null);
        }
        return factory.newPart(fieldName, parts[2]);
    }

    private static Function getFunction(String functionName) {
        return (Function)FUNCTIONS.get(functionName);
    }

    public String format(Map params) {
        StringBuffer sb = new StringBuffer();
        this.format(params, sb);
        return sb.toString();
    }

    public void format(Map params, StringBuffer target) {
        this.rootPart.write(target, params);
    }

    public static void formatObject(Object obj, StringBuffer target) {
        if (obj instanceof String) {
            target.append(obj);
        } else {
            boolean handled = false;
            Iterator iter = OBJECT_FORMATTERS.iterator();
            while (iter.hasNext()) {
                ObjectFormatter formatter = (ObjectFormatter)iter.next();
                if (!formatter.supportsObject(obj)) continue;
                formatter.format(target, obj);
                handled = true;
                break;
            }
            if (!handled) {
                target.append(String.valueOf(obj));
            }
        }
    }

    static String unescapeComma(String string) {
        return string.replaceAll("\\\\,", ",");
    }

    static {
        $assertionsDisabled = !AdvancedMessageFormat.class.desiredAssertionStatus();
        COMMA_SEPARATOR_REGEX = Pattern.compile("(?<!\\\\),");
        PART_FACTORIES = new HashMap();
        OBJECT_FORMATTERS = new ArrayList();
        FUNCTIONS = new HashMap();
        Iterator iter = Service.providers((Class)PartFactory.class, (boolean)true);
        while (iter.hasNext()) {
            PartFactory factory = (PartFactory)iter.next();
            PART_FACTORIES.put(factory.getFormat(), factory);
        }
        iter = Service.providers((Class)ObjectFormatter.class, (boolean)true);
        while (iter.hasNext()) {
            OBJECT_FORMATTERS.add((ObjectFormatter)iter.next());
        }
        iter = Service.providers((Class)Function.class, (boolean)true);
        while (iter.hasNext()) {
            Function function = (Function)iter.next();
            FUNCTIONS.put(function.getName(), function);
        }
    }

    private static class CompositePart
    implements Part {
        protected List parts = new ArrayList();
        private boolean conditional;
        private boolean hasSections = false;

        public CompositePart(boolean conditional) {
            this.conditional = conditional;
        }

        private CompositePart(List parts) {
            this.parts.addAll(parts);
            this.conditional = true;
        }

        public void addChild(Part part) {
            if (part == null) {
                throw new NullPointerException("part must not be null");
            }
            if (this.hasSections) {
                CompositePart composite = (CompositePart)this.parts.get(this.parts.size() - 1);
                composite.addChild(part);
            } else {
                this.parts.add(part);
            }
        }

        public void newSection() {
            if (!this.hasSections) {
                List p = this.parts;
                this.parts = new ArrayList();
                this.parts.add(new CompositePart(p));
                this.hasSections = true;
            }
            this.parts.add(new CompositePart(true));
        }

        public void write(StringBuffer sb, Map params) {
            block2: {
                block3: {
                    if (!this.hasSections) break block3;
                    Iterator iter = this.parts.iterator();
                    while (iter.hasNext()) {
                        CompositePart part = (CompositePart)iter.next();
                        if (!part.isGenerated(params)) continue;
                        part.write(sb, params);
                        break block2;
                    }
                    break block2;
                }
                if (!this.isGenerated(params)) break block2;
                Iterator iter = this.parts.iterator();
                while (iter.hasNext()) {
                    Part part = (Part)iter.next();
                    part.write(sb, params);
                }
            }
        }

        public boolean isGenerated(Map params) {
            if (this.hasSections) {
                Iterator iter = this.parts.iterator();
                while (iter.hasNext()) {
                    Part part = (Part)iter.next();
                    if (!part.isGenerated(params)) continue;
                    return true;
                }
                return false;
            }
            if (this.conditional) {
                Iterator iter = this.parts.iterator();
                while (iter.hasNext()) {
                    Part part = (Part)iter.next();
                    if (part.isGenerated(params)) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return this.parts.toString();
        }
    }

    private static class FunctionPart
    implements Part {
        private Function function;

        public FunctionPart(String functionName) {
            this.function = AdvancedMessageFormat.getFunction(functionName);
            if (this.function == null) {
                throw new IllegalArgumentException("Unknown function: " + functionName);
            }
        }

        public void write(StringBuffer sb, Map params) {
            Object obj = this.function.evaluate(params);
            AdvancedMessageFormat.formatObject(obj, sb);
        }

        public boolean isGenerated(Map params) {
            Object obj = this.function.evaluate(params);
            return obj != null;
        }

        public String toString() {
            return "{#" + this.function.getName() + "}";
        }
    }

    private static class SimpleFieldPart
    implements Part {
        private String fieldName;

        public SimpleFieldPart(String fieldName) {
            this.fieldName = fieldName;
        }

        public void write(StringBuffer sb, Map params) {
            if (!params.containsKey(this.fieldName)) {
                throw new IllegalArgumentException("Message pattern contains unsupported field name: " + this.fieldName);
            }
            Object obj = params.get(this.fieldName);
            AdvancedMessageFormat.formatObject(obj, sb);
        }

        public boolean isGenerated(Map params) {
            Object obj = params.get(this.fieldName);
            return obj != null;
        }

        public String toString() {
            return "{" + this.fieldName + "}";
        }
    }

    private static class TextPart
    implements Part {
        private String text;

        public TextPart(String text) {
            this.text = text;
        }

        public void write(StringBuffer sb, Map params) {
            sb.append(this.text);
        }

        public boolean isGenerated(Map params) {
            return true;
        }

        public String toString() {
            return this.text;
        }
    }

    public static interface Function {
        public Object evaluate(Map var1);

        public Object getName();
    }

    public static interface ObjectFormatter {
        public void format(StringBuffer var1, Object var2);

        public boolean supportsObject(Object var1);
    }

    public static interface PartFactory {
        public Part newPart(String var1, String var2);

        public String getFormat();
    }

    public static interface Part {
        public void write(StringBuffer var1, Map var2);

        public boolean isGenerated(Map var1);
    }
}

