/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.util.HashSet;
import java.util.Set;
import org.apache.fop.afp.fonts.AbstractOutlineFont;
import org.apache.fop.afp.fonts.CharacterSet;

public class DoubleByteFont
extends AbstractOutlineFont {
    private static final Set IDEOGRAPHIC = new HashSet();

    public DoubleByteFont(String name, CharacterSet charSet) {
        super(name, charSet);
    }

    public int getWidth(int character, int size) {
        int charWidth;
        try {
            charWidth = this.charSet.getWidth(DoubleByteFont.toUnicodeCodepoint(character));
        }
        catch (IllegalArgumentException e) {
            charWidth = -1;
        }
        if (charWidth == -1) {
            charWidth = this.inferCharWidth(character);
        }
        return charWidth * size;
    }

    private int inferCharWidth(int character) {
        boolean isIdeographic = false;
        Character.UnicodeBlock charBlock = Character.UnicodeBlock.of((char)character);
        isIdeographic = charBlock == null ? false : IDEOGRAPHIC.contains(charBlock);
        if (isIdeographic) {
            return this.charSet.getEmSpaceIncrement();
        }
        return this.charSet.getSpaceIncrement();
    }

    static {
        IDEOGRAPHIC.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS);
        IDEOGRAPHIC.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
        IDEOGRAPHIC.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A);
    }
}

