/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

public class IntegerList
extends AbstractList<Integer>
implements RandomAccess,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1241962316404811189L;
    private static final int VALUE_SIZE = 64;
    private static final int BASE_SHIFT = 6;
    private static final int OFFSET_MASK = 63;
    private long[] values;
    private final int bitCount;
    private final int mask;
    private int size;

    public IntegerList(int n, int n2) {
        this(n, n2, false);
    }

    public IntegerList(int n, int n2, boolean bl) {
        ArgumentChecks.ensureStrictlyPositive("initialCapacity", n);
        ArgumentChecks.ensureStrictlyPositive("maximalValue", n2);
        this.bitCount = Math.max(1, 32 - Integer.numberOfLeadingZeros(n2));
        this.mask = (1 << this.bitCount) - 1;
        this.values = new long[this.length(n)];
        if (bl) {
            this.size = n;
        }
    }

    private int length(int n) {
        int n2 = (n *= this.bitCount) >>> 6;
        if ((n & 0x3F) != 0) {
            ++n2;
        }
        return n2;
    }

    public int maximalValue() {
        return this.mask;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void resize(int n) {
        ArgumentChecks.ensurePositive("size", n);
        ++this.modCount;
        if (n > this.size) {
            int n2 = this.size * this.bitCount;
            int n3 = n2 & 0x3F;
            if (n3 != 0 && (n2 >>>= 6) < this.values.length) {
                int n4 = n2++;
                this.values[n4] = this.values[n4] & (1L << n3) - 1L;
            }
            int n5 = this.length(n);
            Arrays.fill(this.values, n2, Math.min(n5, this.values.length), 0L);
            if (n5 > this.values.length) {
                this.values = Arrays.copyOf(this.values, n5);
            }
        }
        this.size = n;
    }

    public void fill(int n) {
        long l;
        ArgumentChecks.ensureBetween("value", 0, this.mask, n);
        ++this.modCount;
        if (n == 0) {
            l = 0L;
        } else if (n == this.mask) {
            l = -1L;
        } else {
            switch (this.bitCount) {
                case 1: {
                    n |= n << 1;
                }
                case 2: {
                    n |= n << 2;
                }
                case 4: {
                    n |= n << 4;
                }
                case 8: {
                    n |= n << 8;
                }
                case 16: {
                    n |= n << 16;
                }
                case 32: {
                    l = (long)n & 0xFFFFFFFFL | (long)n << 32;
                    break;
                }
                default: {
                    for (int i = 0; i < this.size; ++i) {
                        this.setUnchecked(i, n);
                    }
                    return;
                }
            }
        }
        Arrays.fill(this.values, 0, this.length(this.size), l);
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    @Override
    public boolean add(Integer n) throws IllegalArgumentException {
        this.addInt(n);
        return true;
    }

    public void addInt(int n) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween("value", 0, this.mask, n);
        ++this.modCount;
        int n2 = this.size++;
        int n3 = this.length(this.size);
        if (n3 > this.values.length) {
            this.values = Arrays.copyOf(this.values, 2 * this.values.length);
        }
        this.setUnchecked(n2, n);
    }

    @Override
    public Integer get(int n) throws IndexOutOfBoundsException {
        return this.getInt(n);
    }

    public int getInt(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.size, n);
        return this.getUnchecked(n);
    }

    private int getUnchecked(int n) {
        int n2 = (n *= this.bitCount) >>> 6;
        int n3 = n & 0x3F;
        int n4 = (int)(this.values[n2] >>> n3);
        if ((n3 = 64 - n3) < this.bitCount) {
            int n5 = (int)this.values[++n2];
            n4 |= n5 << n3;
        }
        return n4 &= this.mask;
    }

    @Override
    public Integer set(int n, Integer n2) throws IndexOutOfBoundsException {
        Integer n3 = this.get(n);
        this.setInt(n, n2);
        return n3;
    }

    public void setInt(int n, int n2) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.size, n);
        ArgumentChecks.ensureBetween("value", 0, this.mask, n2);
        ++this.modCount;
        this.setUnchecked(n, n2);
    }

    private void setUnchecked(int n, int n2) {
        int n3 = (n *= this.bitCount) >>> 6;
        int n4 = n & 0x3F;
        int n5 = n3;
        this.values[n5] = this.values[n5] & ((long)this.mask << n4 ^ 0xFFFFFFFFFFFFFFFFL);
        int n6 = n3++;
        this.values[n6] = this.values[n6] | (long)n2 << n4;
        if ((n4 = 64 - n4) < this.bitCount) {
            int n7 = n3;
            this.values[n7] = this.values[n7] & ((long)this.mask >>> n4 ^ 0xFFFFFFFFFFFFFFFFL);
            int n8 = n3;
            this.values[n8] = this.values[n8] | (long)(n2 >>>= n4);
        }
    }

    @Override
    public Integer remove(int n) throws IndexOutOfBoundsException {
        Integer n2 = this.get(n);
        ++this.modCount;
        this.removeRange(n, n + 1);
        return n2;
    }

    @Override
    public int removeLast() throws NoSuchElementException {
        if (this.size != 0) {
            ++this.modCount;
            return this.getUnchecked(--this.size);
        }
        throw new NoSuchElementException();
    }

    @Override
    protected void removeRange(int n, int n2) {
        ArgumentChecks.ensureValidIndexRange(this.size, n, n2);
        int n3 = n * this.bitCount;
        int n4 = n2 * this.bitCount;
        int n5 = n3 & 0x3F;
        if (n5 == (n4 & 0x3F)) {
            long l = (1L << n5) - 1L;
            long l2 = this.values[n3 >>>= 6] & l;
            System.arraycopy(this.values, n4 >>>= 6, this.values, n3, this.length(this.size) - n4);
            this.values[n3] = this.values[n3] & (l ^ 0xFFFFFFFFFFFFFFFFL) | l2;
        } else {
            while (n2 < this.size) {
                this.setUnchecked(n++, this.getUnchecked(n2++));
            }
        }
        this.size -= n2 - n;
    }

    public int occurrence(int n) {
        int n2 = 0;
        int n3 = this.size;
        for (int i = 0; i < n3; ++i) {
            if (this.getUnchecked(i) != n) continue;
            ++n2;
        }
        return n2;
    }

    public PrimitiveIterator.OfInt iterator() {
        return new PrimitiveSpliterator();
    }

    public Spliterator.OfInt spliterator() {
        return new PrimitiveSpliterator();
    }

    public IntStream stream(boolean bl) {
        return StreamSupport.intStream(this.spliterator(), bl);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.trimToSize();
        objectOutputStream.defaultWriteObject();
    }

    public void trimToSize() {
        this.values = ArraysExt.resize(this.values, this.length(this.size));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            IntegerList integerList = (IntegerList)object;
            if (integerList.size != this.size) {
                return false;
            }
            if (integerList.bitCount == this.bitCount) {
                int n = this.size * this.bitCount;
                int n2 = n & 0x3F;
                if (!JDK9.equals(this.values, 0, n >>>= 6, integerList.values, 0, n)) {
                    return false;
                }
                if (n2 == 0) {
                    return true;
                }
                return ((integerList.values[n] ^ this.values[n]) & (1L << n2) - 1L) == 0L;
            }
        }
        return super.equals(object);
    }

    public IntegerList clone() {
        IntegerList integerList;
        try {
            integerList = (IntegerList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        integerList.values = Arrays.copyOf(this.values, this.length(this.size));
        integerList.modCount = 0;
        return integerList;
    }

    private final class PrimitiveSpliterator
    implements Spliterator.OfInt,
    PrimitiveIterator.OfInt {
        private int stopAt;
        private int nextIndex;
        private int expectedModCount;
        private int lastRemove;

        PrimitiveSpliterator() {
            this.expectedModCount = IntegerList.this.modCount;
            this.stopAt = IntegerList.this.size;
        }

        private PrimitiveSpliterator(PrimitiveSpliterator primitiveSpliterator, int n) {
            this.expectedModCount = primitiveSpliterator.expectedModCount;
            this.stopAt = primitiveSpliterator.nextIndex;
            this.nextIndex = n;
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return this.stopAt - this.nextIndex;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            int n = this.nextIndex;
            int n2 = this.stopAt - n >>> 1;
            if (n2 > 1) {
                this.nextIndex += n2;
                return new PrimitiveSpliterator(this, n);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (IntegerList.this.modCount == this.expectedModCount) {
                return this.nextIndex < this.stopAt;
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                return IntegerList.this.getUnchecked(this.nextIndex++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            boolean bl = this.hasNext();
            if (bl) {
                intConsumer.accept(IntegerList.this.getUnchecked(this.nextIndex++));
            }
            return bl;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            while (this.hasNext()) {
                intConsumer.accept(IntegerList.this.getUnchecked(this.nextIndex++));
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Integer> consumer) {
            if (consumer instanceof IntConsumer) {
                this.forEachRemaining((IntConsumer)((Object)consumer));
            } else {
                while (this.hasNext()) {
                    consumer.accept((Integer)IntegerList.this.getUnchecked(this.nextIndex++));
                }
            }
        }

        @Override
        public void remove() {
            if (this.nextIndex < this.lastRemove || this.nextIndex > this.stopAt) {
                throw new IllegalStateException();
            }
            if (IntegerList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++IntegerList.this.modCount;
            IntegerList.this.removeRange(this.nextIndex - 1, this.nextIndex);
            this.lastRemove = --this.nextIndex;
            --this.stopAt;
        }
    }
}

