/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.Flushable;
import java.io.IOException;
import org.apache.sis.io.Appender;
import org.apache.sis.io.IO;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;

public class LineAppender
extends Appender
implements Flushable {
    private String lineSeparator;
    private int maximalLineLength;
    private int codePointCount;
    private short tabulationWidth = (short)8;
    private boolean isTabulationExpanded;
    private boolean isEndOfLineReplaced;
    private boolean skipLF;
    private boolean isNewLine = true;
    private boolean isEscapeSequence;
    private final StringBuilder buffer = new StringBuilder();
    private int printableLength;

    public LineAppender(Appendable appendable) {
        super(appendable);
        this.maximalLineLength = Integer.MAX_VALUE;
    }

    public LineAppender(Appendable appendable, String string, boolean bl) {
        super(appendable);
        this.maximalLineLength = Integer.MAX_VALUE;
        this.lineSeparator = string;
        this.isEndOfLineReplaced = string != null;
        this.isTabulationExpanded = bl;
    }

    public LineAppender(Appendable appendable, int n, boolean bl) {
        super(appendable);
        ArgumentChecks.ensureStrictlyPositive("maximalLineLength", n);
        this.maximalLineLength = n;
        this.isTabulationExpanded = bl;
    }

    public int getMaximalLineLength() {
        return this.maximalLineLength;
    }

    public void setMaximalLineLength(int n) {
        ArgumentChecks.ensureStrictlyPositive("length", n);
        this.maximalLineLength = n;
    }

    public int getTabulationWidth() {
        return this.tabulationWidth;
    }

    public void setTabulationWidth(int n) {
        ArgumentChecks.ensureStrictlyPositive("width", n);
        ArgumentChecks.ensureBetween("width", 1, Integer.MAX_VALUE, n);
        this.tabulationWidth = (short)n;
    }

    public boolean isTabulationExpanded() {
        return this.isTabulationExpanded;
    }

    public void setTabulationExpanded(boolean bl) {
        this.isTabulationExpanded = bl;
    }

    public String getLineSeparator() {
        return this.isEndOfLineReplaced ? this.lineSeparator : null;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
        this.isEndOfLineReplaced = string != null;
    }

    private void writeLineSeparator() throws IOException {
        if (this.lineSeparator == null) {
            this.lineSeparator = System.lineSeparator();
        }
        this.out.append(this.lineSeparator);
    }

    private void endOfLine() throws IOException {
        this.buffer.setLength(this.printableLength);
        this.deleteSoftHyphen(this.printableLength - 1);
        this.transfer(this.printableLength);
        this.printableLength = 0;
        this.codePointCount = 0;
        this.isEscapeSequence = false;
        this.isNewLine = true;
    }

    private void deleteSoftHyphen(int n) {
        while (--n >= 0) {
            if (this.buffer.charAt(n) != '\u00ad') continue;
            this.buffer.deleteCharAt(n);
            --this.printableLength;
        }
    }

    private void transfer(int n) throws IOException {
        if (this.isNewLine) {
            this.isNewLine = false;
            this.onLineBegin(false);
        }
        this.out.append(this.buffer, 0, n);
        this.buffer.delete(0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void write(int n) throws IOException {
        int n2;
        int n3;
        int n4;
        StringBuilder stringBuilder = this.buffer;
        if (Characters.isLineOrParagraphSeparator(n)) {
            boolean bl;
            switch (n) {
                case 13: {
                    bl = false;
                    this.skipLF = true;
                    break;
                }
                case 10: {
                    bl = this.skipLF;
                    this.skipLF = false;
                    break;
                }
                default: {
                    bl = false;
                    this.skipLF = false;
                }
            }
            if (!bl) {
                this.endOfLine();
            }
            if (!this.isEndOfLineReplaced) {
                this.appendCodePoint(n);
                return;
            }
            if (bl) return;
            this.writeLineSeparator();
            return;
        }
        this.skipLF = false;
        if (Character.isWhitespace(n)) {
            if (this.printableLength != 0) {
                this.deleteSoftHyphen(this.printableLength);
                this.transfer(this.printableLength);
                this.printableLength = 0;
            }
            if (n != 9) {
                ++this.codePointCount;
            } else {
                int n5 = this.tabulationWidth - this.codePointCount % this.tabulationWidth;
                this.codePointCount += n5;
                if (this.isTabulationExpanded) {
                    stringBuilder.append(CharSequences.spaces(n5));
                    return;
                }
            }
            stringBuilder.appendCodePoint(n);
            return;
        }
        stringBuilder.appendCodePoint(n);
        this.printableLength = stringBuilder.length();
        if (n == 27) {
            this.isEscapeSequence = true;
            return;
        }
        if (this.isEscapeSequence) {
            n4 = stringBuilder.charAt(this.printableLength - 2);
            if (n4 != 27) {
                this.isEscapeSequence = n >= 48 && n <= 57;
                return;
            }
            if (n == 91) {
                return;
            }
            this.isEscapeSequence = false;
        }
        if (++this.codePointCount <= this.maximalLineLength) return;
        block8: for (n4 = stringBuilder.length(); n4 > 0; n4 -= n3) {
            n2 = stringBuilder.codePointBefore(n4);
            n3 = Character.charCount(n2);
            switch (n2) {
                case 45: {
                    if (n4 >= n3 && !Character.isLetter(stringBuilder.codePointBefore(n4 - n3))) break;
                }
                case 173: 
                case 8208: {
                    this.transfer(n4);
                    break block8;
                }
            }
        }
        this.writeLineSeparator();
        n4 = stringBuilder.length();
        for (n2 = 0; n2 < n4; n2 += Character.charCount(n3)) {
            n3 = stringBuilder.codePointAt(n2);
            if (Character.isWhitespace(n3)) continue;
            stringBuilder.delete(0, n2);
            break;
        }
        this.printableLength = stringBuilder.length();
        this.codePointCount = stringBuilder.codePointCount(0, this.printableLength);
        this.onLineBegin(true);
    }

    @Override
    public Appendable append(char c) throws IOException {
        int n = this.toCodePoint(c);
        if (n >= 0) {
            this.write(n);
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
        ArgumentChecks.ensureValidIndexRange(charSequence.length(), n, n2);
        if (this.lineSeparator == null) {
            this.lineSeparator = this.lineSeparator(charSequence, n, n2);
        }
        n = this.appendSurrogate(charSequence, n, n2);
        while (n < n2) {
            int n3;
            if ((n3 = this.toCodePoint(charSequence.charAt(n++))) < 0) continue;
            this.write(n3);
        }
        return this;
    }

    public void clear() throws IOException {
        this.endOfLine();
        this.skipLF = false;
    }

    @Override
    public void flush() throws IOException {
        this.out.append(this.buffer);
        this.buffer.setLength(0);
        this.printableLength = 0;
        IO.flush(this.out);
    }

    protected void onLineBegin(boolean bl) throws IOException {
    }
}

