/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import org.apache.sis.io.Appender;
import org.apache.sis.io.IO;

final class AppendableWriter
extends Writer {
    private final Appendable out;

    AppendableWriter(Appendable appendable) {
        super(AppendableWriter.getLock(appendable));
        this.out = appendable;
    }

    private static Object getLock(Appendable appendable) {
        while (appendable instanceof Appender) {
            appendable = ((Appender)appendable).out;
        }
        if (appendable instanceof StringWriter) {
            return ((StringWriter)appendable).getBuffer();
        }
        return appendable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(char c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(c);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append((char)n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(charSequence);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(CharSequence charSequence, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(charSequence, n, n2);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(string, n, n + n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(CharBuffer.wrap(cArray, n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            IO.flush(this.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            IO.close(this.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return IO.toString(this.out);
        }
    }
}

