/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sis.internal.system.Threads;

public final class CommonExecutor
extends AtomicInteger
implements ThreadFactory {
    public static final int PARALLELISM = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
    private static final ThreadPoolExecutor INSTANCE;

    public static ExecutorService instance() {
        return INSTANCE;
    }

    public static boolean unschedule(Future<?> future) {
        if (future instanceof Runnable) {
            return INSTANCE.remove((Runnable)((Object)future));
        }
        return false;
    }

    private CommonExecutor() {
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(Threads.SIS, runnable, "Background worker #" + this.incrementAndGet());
        thread.setPriority(3);
        thread.setDaemon(true);
        return thread;
    }

    static {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(PARALLELISM, PARALLELISM, 2L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(1000000), new CommonExecutor());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        INSTANCE = threadPoolExecutor;
    }
}

