/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.compiler.selectors.SelectorsManipulator;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

class SelectorPartsListBuilder {
    private SelectorsManipulator manipulator = new SelectorsManipulator();
    private List<SelectorPart> newInSelectorParts = new ArrayList<SelectorPart>();

    public List<SelectorPart> getParts() {
        return this.newInSelectorParts;
    }

    public void directlyAttachNonNull(SelectorPart part) {
        if (part != null) {
            this.directlyAttach(part);
        }
    }

    public void directlyAttach(SelectorPart part) {
        if (this.newInSelectorParts.isEmpty()) {
            this.add(part);
        } else {
            SelectorPart tail = ArraysUtils.last(this.newInSelectorParts);
            this.manipulator.directlyJoinParts(tail, part);
        }
    }

    public void directlyAttach(List<SelectorPart> list) {
        if (!this.newInSelectorParts.isEmpty()) {
            SelectorPart tail = ArraysUtils.last(this.newInSelectorParts);
            SelectorPart firstReplaceBy = list.remove(0);
            this.manipulator.directlyJoinParts(tail, firstReplaceBy);
        }
        this.addAll(list);
    }

    public void addAll(List<SelectorPart> list) {
        this.newInSelectorParts.addAll(list);
    }

    public void addNonNull(SelectorPart part) {
        if (part != null) {
            this.add(part);
        }
    }

    public void add(SelectorPart part) {
        this.newInSelectorParts.add(part);
    }

    public void addUpTo(List<SelectorPart> inSelectorParts, SelectorPart firstMatch) {
        this.newInSelectorParts.addAll(ArraysUtils.chopUpTo(inSelectorParts, firstMatch));
    }

    public String toString() {
        return this.newInSelectorParts.toString();
    }
}

