/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes.view;

import com.github.sommeri.less4j.core.compiler.scopes.AbstractScopesTree;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.IScopesTree;
import com.github.sommeri.less4j.core.compiler.scopes.ScopeFactory;
import com.github.sommeri.less4j.core.compiler.scopes.view.ScopeView;
import java.util.ArrayList;
import java.util.List;

public class ScopesTreeView
extends AbstractScopesTree {
    protected ScopeView scope;
    private IScope joinToParentTree;
    private final IScopesTree originalStructure;
    private ScopeView publicParent;
    private List<IScope> publicChilds = null;
    private IScope fakeChildScope;
    private ScopeView fakeChildScopeView;

    public ScopesTreeView(IScopesTree originalStructure, IScope joinToParentTree, ScopeView publicParent, ScopeView publicChild) {
        this.originalStructure = originalStructure;
        this.joinToParentTree = joinToParentTree;
        this.publicParent = publicParent;
        if (publicChild != null) {
            this.fakeChildScope = publicChild.getUnderlying();
            this.fakeChildScopeView = publicChild;
        }
    }

    public void setScope(ScopeView scope) {
        this.scope = scope;
    }

    @Override
    public void addChild(IScope child) {
        throw new IllegalStateException("Scopes view does not accept new childs.");
    }

    @Override
    public void setParent(IScope parent) {
        throw new IllegalStateException("Scopes view does not accept new parents.");
    }

    @Override
    public ScopeView getParent() {
        if (this.publicParent != null) {
            return this.publicParent;
        }
        this.publicParent = this.createPublicParent();
        return this.publicParent;
    }

    @Override
    public List<IScope> getChilds() {
        if (this.publicChilds != null) {
            return this.publicChilds;
        }
        this.publicChilds = this.createPublicChilds();
        return this.publicChilds;
    }

    protected List<IScope> createPublicChilds() {
        List<IScope> realChilds = this.originalStructure.getChilds();
        if (realChilds == null) {
            return null;
        }
        ArrayList<IScope> result = new ArrayList<IScope>();
        for (IScope childScope : realChilds) {
            if (this.fakeChildScope != null && this.fakeChildScope.equals(childScope)) {
                result.add(this.fakeChildScopeView);
                continue;
            }
            result.add(ScopeFactory.createChildScopeView(childScope, this.scope, this.joinToParentTree));
        }
        return result;
    }

    protected ScopeView createPublicParent() {
        IScope realParent = this.originalStructure.getParent();
        if (realParent != null) {
            return ScopeFactory.createParentScopeView(realParent, this.scope, this.joinToParentTree);
        }
        if (this.joinToParentTree == null) {
            return null;
        }
        return ScopeFactory.createScopeViewJoint(this.joinToParentTree, this.scope);
    }
}

