/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Guard;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class GuardNegated
extends Guard {
    private boolean isNegated;
    private Guard guard;

    public GuardNegated(HiddenTokenAwareTree underlyingStructure, Guard guard) {
        this(underlyingStructure, true, guard);
    }

    public GuardNegated(HiddenTokenAwareTree token, boolean isNegated, Guard guard) {
        super(token);
        this.isNegated = isNegated;
        this.guard = guard;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public void setNegated(boolean isNegated) {
        this.isNegated = isNegated;
    }

    public Guard getGuard() {
        return this.guard;
    }

    public void setGuard(Guard guard) {
        this.guard = guard;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.guard);
    }

    @Override
    public Guard.Type getGuardType() {
        return Guard.Type.NEGATED;
    }

    @Override
    public GuardNegated clone() {
        GuardNegated result = (GuardNegated)super.clone();
        result.guard = this.guard == null ? null : this.guard.clone();
        result.configureParentToAllChilds();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append(this.isNegated() ? "!" : "").append(this.guard).append("]");
        return builder.toString();
    }
}

