/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.CharSequences;

final class LogAdapter
implements Appendable {
    private final StringBuilder buffer = new StringBuilder();
    private final StoreListeners listeners;

    LogAdapter(StoreListeners storeListeners) {
        this.listeners = storeListeners;
    }

    @Override
    public Appendable append(CharSequence charSequence) {
        if (charSequence.length() != 0) {
            CharSequence[] charSequenceArray = CharSequences.splitOnEOL((CharSequence)charSequence);
            int n = charSequenceArray.length;
            char c = charSequence.charAt(charSequence.length() - 1);
            if (c != '\r' && c != '\n') {
                --n;
            }
            for (int i = 0; i < n; ++i) {
                CharSequence charSequence2 = charSequenceArray[i];
                if (this.buffer.length() != 0) {
                    this.warning(this.buffer.append(charSequence2));
                    this.buffer.setLength(0);
                    continue;
                }
                this.warning(charSequence2);
            }
            if (n != charSequenceArray.length) {
                this.buffer.append(charSequenceArray[n]);
            }
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            charSequence = "null";
        }
        return this.append(charSequence.subSequence(n, n2));
    }

    @Override
    public Appendable append(char c) {
        if (c != '\r' && c != '\n') {
            this.buffer.append(c);
        } else if (this.buffer.length() != 0) {
            this.warning(this.buffer);
            this.buffer.setLength(0);
        }
        return this;
    }

    private void warning(CharSequence charSequence) {
        if ((charSequence = CharSequences.trimWhitespaces((CharSequence)charSequence)).length() != 0) {
            this.listeners.warning(charSequence.toString());
        }
    }
}

