/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;

public class TimeCoordUnion
extends TimeCoord {
    private final List<Val> values;

    public TimeCoordUnion(int code, List<TimeCoord> timeCoords, TimeCoord canon) {
        super(code, canon.getRunDate(), canon.getTimeUnit(), null);
        if (canon.isInterval()) {
            this.values = this.makeUnionIntv(timeCoords);
            this.intervals = new ArrayList(this.values.size());
            for (Val val : this.values) {
                this.intervals.add(val.tinv);
            }
        } else {
            this.values = this.makeUnionReg(timeCoords);
            this.coords = new ArrayList(this.values.size());
            for (Val val : this.values) {
                int offset = TimeCoord.getOffset(this.getRunDate(), val.val, this.getTimeUnit());
                this.coords.add(offset);
            }
        }
    }

    public TimeCoordUnion(int code, String units, List coords, int[] partition, int[] index) {
        super(code, units, coords);
        this.values = new ArrayList<Val>(partition.length);
        for (int i = 0; i < partition.length; ++i) {
            this.values.add(new Val((CalendarDate)null, partition[i], index[i]));
        }
    }

    public Val getVal(int idx) {
        return this.values.get(idx);
    }

    public List<Val> getValues() {
        return this.values;
    }

    private List<Val> makeUnionReg(List<TimeCoord> timeCoords) {
        HashMap<CalendarDate, Val> values = new HashMap<CalendarDate, Val>();
        for (int partno = 0; partno < timeCoords.size(); ++partno) {
            TimeCoord tc = timeCoords.get(partno);
            if (tc == null) continue;
            CalendarDateUnit thisUnit = CalendarDateUnit.of(null, tc.getUnits());
            List<Integer> vals = tc.getCoords();
            for (int idx = 0; idx < vals.size(); ++idx) {
                CalendarDate d = thisUnit.makeCalendarDate(vals.get(idx));
                Val uval = (Val)values.get(d);
                if (uval == null) {
                    uval = new Val(d, partno, idx);
                    values.put(d, uval);
                    continue;
                }
                uval.partition = partno;
                uval.index = idx;
            }
        }
        ArrayList<Val> valuesList = new ArrayList<Val>(values.values());
        Collections.sort(valuesList);
        return valuesList;
    }

    private List<Val> makeUnionIntv(List<TimeCoord> timeCoords) {
        HashMap<TimeCoord.Tinv, Val> values = new HashMap<TimeCoord.Tinv, Val>();
        for (int partno = 0; partno < timeCoords.size(); ++partno) {
            TimeCoord tc = timeCoords.get(partno);
            if (tc == null) continue;
            List<TimeCoord.Tinv> vals = tc.getIntervals();
            for (int idx = 0; idx < vals.size(); ++idx) {
                TimeCoord.Tinv org = vals.get(idx);
                TimeCoord.Tinv convert = org.convertReferenceDate(tc.getRunDate(), tc.getTimeUnit(), this.getRunDate(), this.getTimeUnit());
                Val uval = (Val)values.get(convert);
                if (uval == null) {
                    uval = new Val(convert, partno, idx);
                    values.put(convert, uval);
                    continue;
                }
                uval.partition = partno;
                uval.index = idx;
            }
        }
        ArrayList<Val> valuesList = new ArrayList<Val>(values.values());
        Collections.sort(valuesList);
        return valuesList;
    }

    @Override
    public boolean equalsData(TimeCoord tother) {
        if (!super.equalsData(tother)) {
            return false;
        }
        TimeCoordUnion o = (TimeCoordUnion)tother;
        for (int i = 0; i < this.values.size(); ++i) {
            Val val1 = this.values.get(i);
            Val val2 = o.getVal(i);
            if (val1.partition != val2.partition) {
                return false;
            }
            if (val1.index == val2.index) continue;
            return false;
        }
        return true;
    }

    public static int findUnique(List<TimeCoordUnion> timeIndexList, TimeCoordUnion want) {
        if (want == null) {
            return -1;
        }
        for (int i = 0; i < timeIndexList.size(); ++i) {
            if (!want.equalsData(timeIndexList.get(i))) continue;
            return i;
        }
        timeIndexList.add(want);
        return timeIndexList.size() - 1;
    }

    public static class Val
    implements Comparable<Val> {
        TimeCoord.Tinv tinv;
        CalendarDate val;
        int partition;
        int index;

        Val(TimeCoord.Tinv tinv, int partition, int index) {
            this.tinv = tinv;
            this.partition = partition;
            this.index = index;
        }

        Val(CalendarDate val, int partition, int index) {
            this.val = val;
            this.partition = partition;
            this.index = index;
        }

        public TimeCoord.Tinv getTinv() {
            return this.tinv;
        }

        public CalendarDate getVal() {
            return this.val;
        }

        public int getPartition() {
            return this.partition;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public int compareTo(Val o) {
            if (this.val != null) {
                return this.val.compareTo(o.val);
            }
            return this.tinv.compareTo(o.tinv);
        }
    }
}

