/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.Conversions;
import com.github.tomakehurst.wiremock.admin.Paginator;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Date;
import java.util.List;

public class LimitAndSinceDatePaginator
implements Paginator<ServeEvent> {
    private final List<ServeEvent> source;
    private final Integer limit;
    private final Date since;

    public LimitAndSinceDatePaginator(List<ServeEvent> source, Integer limit, Date since) {
        Preconditions.checkArgument((limit == null || limit >= 0 ? 1 : 0) != 0, (Object)"limit must be 0 or greater");
        this.source = source;
        this.limit = limit;
        this.since = since;
    }

    public static LimitAndSinceDatePaginator fromRequest(List<ServeEvent> source, Request request) {
        return new LimitAndSinceDatePaginator(source, Conversions.toInt(request.queryParameter("limit")), Conversions.toDate(request.queryParameter("since")));
    }

    @Override
    public List<ServeEvent> select() {
        FluentIterable chain = FluentIterable.from(this.source);
        return chain.filter((Predicate)new Predicate<ServeEvent>(){

            public boolean apply(ServeEvent input) {
                return LimitAndSinceDatePaginator.this.since == null || input.getRequest().getLoggedDate().after(LimitAndSinceDatePaginator.this.since);
            }
        }).limit(((Integer)MoreObjects.firstNonNull((Object)this.limit, (Object)this.source.size())).intValue()).toList();
    }

    @Override
    public int getTotal() {
        return this.source.size();
    }
}

