/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.Cache;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.CacheFactory;
import org.castor.cache.CacheFactoryRegistry;
import org.castor.jdo.engine.ConnectionFactory;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.cache.CacheEntry;
import org.castor.util.Configuration;
import org.castor.util.Messages;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.ClassMolderHelper;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.xml.ClassDescriptorResolver;

public final class LockEngine {
    private static Log _log = LogFactory.getFactory().getInstance(LockEngine.class);
    private static CacheFactoryRegistry _cacheFactoryRegistry;
    private HashMap _typeInfo = new HashMap();
    private HashMap _xaTx = new HashMap();
    private ConnectionFactory _connectionFactory;
    private PersistenceFactory _persistenceFactory;

    public LockEngine(ConnectionFactory connectionFactory, ClassDescriptorResolver cdResolver, PersistenceFactory persistenceFactory) throws MappingException {
        if (_cacheFactoryRegistry == null) {
            Configuration config = Configuration.getInstance();
            _cacheFactoryRegistry = new CacheFactoryRegistry(config);
        }
        this._connectionFactory = connectionFactory;
        this._persistenceFactory = persistenceFactory;
        try {
            ClassMolder molder;
            Iterator itor;
            Vector v = ClassMolderHelper.resolve(cdResolver, this, this._persistenceFactory);
            this._typeInfo = new HashMap();
            Enumeration enumeration = v.elements();
            HashSet<ClassMolder> processedClasses = new HashSet<ClassMolder>();
            HashSet freshClasses = new HashSet();
            while (enumeration.hasMoreElements()) {
                freshClasses.add(enumeration.nextElement());
            }
            int counter = 0;
            do {
                counter = freshClasses.size();
                itor = freshClasses.iterator();
                while (itor.hasNext()) {
                    molder = (ClassMolder)itor.next();
                    ClassMolder extend = molder.getExtends();
                    if (extend == null) {
                        Cache cache = null;
                        try {
                            cache = _cacheFactoryRegistry.getCache(molder.getCacheParams(), cdResolver.getMappingLoader().getClassLoader());
                        }
                        catch (CacheAcquireException e) {
                            String msg = Messages.message("persist.cacheCreationFailed");
                            _log.error((Object)msg, (Throwable)e);
                            throw new MappingException(msg, e);
                        }
                        TypeInfo info = new TypeInfo(molder, new HashMap(), cache);
                        this._typeInfo.put(molder.getName(), info);
                        itor.remove();
                        processedClasses.add(molder);
                        continue;
                    }
                    if (!processedClasses.contains(molder.getExtends())) continue;
                    TypeInfo baseInfo = (TypeInfo)this._typeInfo.get(extend.getName());
                    this._typeInfo.put(molder.getName(), new TypeInfo(molder, baseInfo));
                    itor.remove();
                    processedClasses.add(molder);
                }
            } while (freshClasses.size() > 0 && counter != freshClasses.size());
            if (freshClasses.size() > 0) {
                itor = freshClasses.iterator();
                while (itor.hasNext()) {
                    molder = (ClassMolder)itor.next();
                    _log.error((Object)("The base class, " + molder.getExtends().getName() + ", of the extends class ," + molder.getName() + " can not be resolved! "));
                }
                throw new MappingException("Some base class can not be resolved!");
            }
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Declared Class not found!");
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this._connectionFactory;
    }

    public ClassMolder getClassMolder(Class cls) {
        TypeInfo info = (TypeInfo)this._typeInfo.get(cls.getName());
        if (info != null && !info.molder.isDependent()) {
            return info.molder;
        }
        return null;
    }

    public ClassMolder getClassMolderWithDependent(Class cls) {
        TypeInfo info = (TypeInfo)this._typeInfo.get(cls.getName());
        return info != null ? info.molder : null;
    }

    public ClassMolder getClassMolderByQuery(String name) {
        Iterator typeIterator = this._typeInfo.values().iterator();
        while (typeIterator.hasNext()) {
            TypeInfo info = (TypeInfo)typeIterator.next();
            if (info.molder.getNamedQuery(name) == null) continue;
            return info.molder;
        }
        return null;
    }

    public Persistence getPersistence(Class cls) {
        ClassMolder molder = this.getClassMolder(cls);
        if (molder != null) {
            return molder.getPersistence();
        }
        return null;
    }

    public OID load(TransactionContext tx, OID oid, ProposedEntity proposedObject, AccessMode suggestedAccessMode, int timeout) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException, ClassNotPersistenceCapableException, ObjectDeletedWaitingForLockException {
        return this.load(tx, oid, proposedObject, suggestedAccessMode, timeout, null);
    }

    public OID load(TransactionContext tx, OID oid, ProposedEntity proposedObject, AccessMode suggestedAccessMode, int timeout, QueryResults results) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException, ClassNotPersistenceCapableException, ObjectDeletedWaitingForLockException {
        Object stamp;
        OID lockedOid;
        ObjectLock lock;
        boolean succeed;
        TypeInfo typeInfo;
        block13: {
            typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
            if (typeInfo == null) {
                throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", oid.getName()));
            }
            ClassMolder molder = oid.getMolder();
            AccessMode accessMode = molder.getAccessMode(suggestedAccessMode);
            succeed = false;
            lock = null;
            short action = accessMode == AccessMode.Exclusive || accessMode == AccessMode.DbLocked ? (short)2 : 1;
            lock = typeInfo.acquire(oid, tx, action, timeout);
            lockedOid = lock.getOID();
            stamp = typeInfo.molder.load(tx, lockedOid, lock, proposedObject, suggestedAccessMode, results);
            if (!proposedObject.isExpanded()) break block13;
            typeInfo.release(oid, tx);
            OID oID = oid;
            Object var17_18 = null;
            if (lock != null) {
                lock.confirm(tx, succeed);
            }
            return oID;
        }
        try {
            block14: {
                try {
                    succeed = true;
                    lockedOid.setStamp(stamp);
                    if (lockedOid != null) {
                        oid = lockedOid;
                    }
                    if (!_log.isDebugEnabled()) break block14;
                    if (proposedObject.isExpanded()) {
                        _log.debug((Object)Messages.format("jdo.loading.with.id", proposedObject.getActualEntityClass(), oid.getIdentity()));
                        break block14;
                    }
                    _log.debug((Object)Messages.format("jdo.loading.with.id", typeInfo.molder.getName(), oid.getIdentity()));
                }
                catch (ObjectDeletedWaitingForLockException except) {
                    throw new ObjectNotFoundException(Messages.format("persist.objectNotFound", oid.getName(), oid.getIdentity()), except);
                }
                catch (LockNotGrantedException e) {
                    if (lock != null) {
                        lock.release(tx);
                    }
                    throw e;
                }
            }
            Object var17_19 = null;
            if (lock != null) {
                lock.confirm(tx, succeed);
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            if (lock != null) {
                lock.confirm(tx, succeed);
            }
            throw throwable;
        }
        return oid;
    }

    public void markCreate(TransactionContext tx, OID oid, Object object) throws PersistenceException, LockNotGrantedException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", oid.getName()));
        }
        typeInfo.molder.markCreate(tx, oid, null, object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OID create(TransactionContext tx, OID oid, Object object) throws DuplicateIdentityException, PersistenceException, ClassNotPersistenceCapableException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(object.getClass().getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", object.getClass().getName()));
        }
        ObjectLock lock = null;
        if (oid.getIdentity() != null) {
            lock = null;
            boolean succeed = false;
            try {
                try {
                    lock = typeInfo.acquire(oid, tx, (short)3, 0);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)Messages.format("jdo.creating.with.id", typeInfo.molder.getName(), oid.getIdentity()));
                    }
                    oid = lock.getOID();
                    typeInfo.molder.create(tx, oid, lock, object);
                    succeed = true;
                    oid.setDbLock(true);
                    OID oID = oid;
                    Object var10_13 = null;
                    if (lock == null) return oID;
                    lock.confirm(tx, succeed);
                    return oID;
                }
                catch (LockNotGrantedException except) {
                    throw new DuplicateIdentityException(Messages.format("persist.duplicateIdentity", object.getClass().getName(), oid.getIdentity()), except);
                }
                catch (DuplicateIdentityException except) {
                    throw except;
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (lock == null) throw throwable;
                lock.confirm(tx, succeed);
                throw throwable;
            }
        }
        boolean succeed = false;
        try {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)Messages.format("jdo.creating.with.id", typeInfo.molder.getName(), oid.getIdentity()));
                }
                lock = typeInfo.acquire(oid, tx, (short)3, 0);
                oid = lock.getOID();
                Identity newids = typeInfo.molder.create(tx, oid, lock, object);
                succeed = true;
                oid.setDbLock(true);
                OID newoid = new OID(oid.getMolder(), oid.getDepends(), newids);
                typeInfo.rename(oid, newoid, tx);
                OID oID = newoid;
                Object var12_18 = null;
                if (lock == null) return oID;
                lock.confirm(tx, succeed);
                return oID;
            }
            catch (LockNotGrantedException e) {
                e.printStackTrace();
                throw new PersistenceException(Messages.format("persist.nested", "Key Generator Failure. Duplicated Identity is generated!"));
            }
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (lock == null) throw throwable;
            lock.confirm(tx, succeed);
            throw throwable;
        }
    }

    public void delete(TransactionContext tx, OID oid) throws PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        try {
            typeInfo.assure(oid, tx, true);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)Messages.format("jdo.removing", typeInfo.molder.getName(), oid.getIdentity()));
            }
            typeInfo.molder.delete(tx, oid);
        }
        catch (LockNotGrantedException except) {
            throw new IllegalStateException(Messages.format("persist.internal", "Attempt to delete object for which no lock was acquired"));
        }
    }

    public void markDelete(TransactionContext tx, OID oid, Object object, int timeout) throws PersistenceException, LockNotGrantedException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        ObjectLock lock = typeInfo.upgrade(oid, tx, timeout);
        typeInfo.molder.markDelete(tx, oid, lock, object);
        lock.expire();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean update(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode, int timeout) throws ObjectNotFoundException, LockNotGrantedException, ObjectModifiedException, PersistenceException, ClassNotPersistenceCapableException, ObjectDeletedWaitingForLockException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", oid.getName()));
        }
        boolean succeed = false;
        ObjectLock lock = null;
        try {
            try {
                lock = typeInfo.acquire(oid, tx, (short)4, timeout);
                oid = lock.getOID();
                boolean creating = typeInfo.molder.update(tx, oid, lock, object, suggestedAccessMode);
                succeed = !creating;
                boolean bl = creating;
                Object var12_13 = null;
                if (lock == null) return bl;
                lock.confirm(tx, succeed);
                return bl;
            }
            catch (ObjectModifiedException e) {
                throw e;
            }
            catch (ObjectDeletedWaitingForLockException except) {
                throw new ObjectNotFoundException(Messages.format("persist.objectNotFound", oid.getName(), oid.getIdentity()), except);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (lock == null) throw throwable;
            lock.confirm(tx, succeed);
            throw throwable;
        }
    }

    public OID preStore(TransactionContext tx, OID oid, Object object, int timeout) throws LockNotGrantedException, PersistenceException {
        boolean modified;
        ObjectLock lock = null;
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(object.getClass().getName());
        oid = new OID(typeInfo.molder, oid.getIdentity());
        try {
            lock = typeInfo.assure(oid, tx, false);
            oid = lock.getOID();
            modified = typeInfo.molder.preStore(tx, oid, lock, object, timeout);
        }
        catch (LockNotGrantedException e) {
            throw e;
        }
        catch (ObjectModifiedException e) {
            lock.invalidate(tx);
            throw e;
        }
        catch (ObjectDeletedException e) {
            lock.delete(tx);
            throw e;
        }
        if (modified) {
            return oid;
        }
        return null;
    }

    public void store(TransactionContext tx, OID oid, Object object) throws LockNotGrantedException, ObjectDeletedException, ObjectModifiedException, DuplicateIdentityException, PersistenceException {
        ObjectLock lock = null;
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        try {
            lock = typeInfo.assure(oid, tx, false);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)Messages.format("jdo.storing.with.id", typeInfo.molder.getName(), oid.getIdentity()));
            }
            typeInfo.molder.store(tx, oid, lock, object);
        }
        catch (ObjectModifiedException e) {
            lock.invalidate(tx);
            throw e;
        }
        catch (DuplicateIdentityException e) {
            throw e;
        }
        catch (LockNotGrantedException e) {
            throw e;
        }
        catch (PersistenceException e) {
            lock.invalidate(tx);
            throw e;
        }
    }

    public void writeLock(TransactionContext tx, OID oid, int timeout) throws LockNotGrantedException, PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        try {
            typeInfo.upgrade(oid, tx, timeout);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (ObjectDeletedWaitingForLockException e) {
            throw new IllegalStateException("Object deleted waiting for lock?????????");
        }
        catch (LockNotGrantedException e) {
            throw e;
        }
    }

    public void softLock(TransactionContext tx, OID oid, int timeout) throws LockNotGrantedException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        typeInfo.upgrade(oid, tx, timeout);
    }

    public void revertObject(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        try {
            ObjectLock lock = typeInfo.assure(oid, tx, false);
            typeInfo.molder.revertObject(tx, oid, lock, object);
        }
        catch (LockNotGrantedException e) {
            throw new IllegalStateException("Write Lock expected!");
        }
        catch (PersistenceException except) {
            throw except;
        }
    }

    public void updateCache(TransactionContext tx, OID oid, Object object) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        ObjectLock lock = typeInfo.assure(oid, tx, true);
        typeInfo.molder.updateCache(tx, oid, lock, object);
    }

    public void releaseLock(TransactionContext tx, OID oid) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        ObjectLock lock = typeInfo.release(oid, tx);
        lock.getOID().setDbLock(false);
    }

    public void forgetObject(TransactionContext tx, OID oid) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        typeInfo.assure(oid, tx, true);
        typeInfo.delete(oid, tx);
        typeInfo.release(oid, tx);
    }

    public boolean expireCache(TransactionContext tx, OID oid, int timeout) throws ClassNotPersistenceCapableException, LockNotGrantedException, ObjectDeletedException, PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", oid.getName()));
        }
        boolean succeed = false;
        ObjectLock lock = null;
        try {
            block9: {
                try {
                    if (!typeInfo.isCached(oid)) break block9;
                    lock = typeInfo.acquire(oid, tx, (short)2, timeout);
                    typeInfo.molder.expireCache(tx, lock);
                    lock.expire();
                    succeed = true;
                }
                catch (LockNotGrantedException e) {
                    throw e;
                }
                catch (ObjectDeletedException e) {
                    throw e;
                }
                catch (PersistenceException e) {
                    throw e;
                }
            }
            Object var9_7 = null;
            if (lock != null) {
                lock.confirm(tx, succeed);
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (lock != null) {
                lock.confirm(tx, succeed);
            }
            throw throwable;
        }
        return succeed;
    }

    public void expireCache(Class cls) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(cls.getName());
        if (typeInfo != null) {
            typeInfo.expireCache();
        }
    }

    public void expireCache() {
        Iterator iter = this._typeInfo.values().iterator();
        while (iter.hasNext()) {
            ((TypeInfo)iter.next()).expireCache();
        }
    }

    public void dumpCache() {
        Iterator iter = this._typeInfo.values().iterator();
        while (iter.hasNext()) {
            ((TypeInfo)iter.next()).dumpCache();
        }
    }

    public void closeCaches() {
        Iterator<Object> iter = this._typeInfo.values().iterator();
        while (iter.hasNext()) {
            ((TypeInfo)iter.next()).closeCache();
        }
        iter = _cacheFactoryRegistry.getCacheFactories().iterator();
        while (iter.hasNext()) {
            ((CacheFactory)iter.next()).shutdown();
        }
    }

    public void dumpCache(Class cls) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(cls.getName());
        if (typeInfo != null) {
            typeInfo.dumpCache();
        }
    }

    public HashMap getXATransactions() {
        return this._xaTx;
    }

    public boolean isCached(Class cls, Object oid) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(cls.getName());
        return typeInfo.isCached(oid);
    }

    public boolean isLocked(Class cls, OID oid) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(cls.getName());
        return typeInfo.isLocked(oid);
    }

    private class TypeInfo {
        private final ClassMolder molder;
        private final String name;
        private final HashMap locks;
        private final Cache cache;

        private TypeInfo(ClassMolder molder, HashMap locks, Cache cache) {
            this.name = molder.getName();
            this.molder = molder;
            this.locks = locks;
            this.cache = cache;
        }

        private TypeInfo(ClassMolder molder, TypeInfo base) {
            this(molder, base.locks, base.cache);
        }

        public void closeCache() {
            this.cache.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dumpCache() {
            _log.info((Object)(this.name + ".dumpCache()..."));
            HashMap hashMap = this.locks;
            synchronized (hashMap) {
                ObjectLock entry;
                Iterator iter = this.locks.values().iterator();
                while (iter.hasNext()) {
                    entry = (ObjectLock)iter.next();
                    _log.info((Object)("In locks: " + entry));
                }
                iter = this.cache.values().iterator();
                while (iter.hasNext()) {
                    entry = (ObjectLock)iter.next();
                    _log.info((Object)("In cache: " + entry.getOID()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expireCache() {
            HashMap hashMap = this.locks;
            synchronized (hashMap) {
                Iterator iter = this.locks.values().iterator();
                while (iter.hasNext()) {
                    ObjectLock objectLock = (ObjectLock)iter.next();
                    objectLock.expire();
                    iter.remove();
                }
                this.cache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLock acquire(OID oid, TransactionContext tx, short lockAction, int timeout) throws ObjectDeletedWaitingForLockException, LockNotGrantedException {
            HashMap hashMap;
            ObjectLock objectLock;
            ObjectLock entry = null;
            HashMap hashMap2 = this.locks;
            synchronized (hashMap2) {
                CacheEntry cachedEntry;
                entry = (ObjectLock)this.locks.get(oid);
                if (entry == null && (cachedEntry = (CacheEntry)this.cache.remove(oid)) != null) {
                    entry = new ObjectLock(cachedEntry);
                    this.locks.put(oid, entry);
                    OID cacheOid = entry.getOID();
                    if (oid.getName().equals(cacheOid.getName())) {
                        entry.setOID(oid);
                        this.locks.put(oid, entry);
                    } else {
                        entry = null;
                    }
                }
                if (entry == null) {
                    entry = new ObjectLock(oid);
                    this.locks.put(oid, entry);
                } else {
                    oid = entry.getOID();
                }
                entry.enter();
            }
            boolean failed = true;
            try {
                switch (lockAction) {
                    case 1: {
                        entry.acquireLoadLock(tx, false, timeout);
                        break;
                    }
                    case 2: {
                        entry.acquireLoadLock(tx, true, timeout);
                        break;
                    }
                    case 3: {
                        entry.acquireCreateLock(tx);
                        break;
                    }
                    case 4: {
                        entry.acquireUpdateLock(tx, timeout);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("lockType " + lockAction + " is undefined!");
                    }
                }
                failed = false;
                objectLock = entry;
                Object var11_11 = null;
                hashMap = this.locks;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                HashMap hashMap3 = this.locks;
                synchronized (hashMap3) {
                    entry.leave();
                    if (failed && entry.isDisposable()) {
                        this.locks.remove(oid);
                        if (entry.isExpired()) {
                            this.cache.expire(oid);
                            entry.expired();
                        } else {
                            this.cache.put(oid, new CacheEntry(entry));
                        }
                    }
                }
                throw throwable;
            }
            synchronized (hashMap) {
                entry.leave();
                if (failed && entry.isDisposable()) {
                    this.locks.remove(oid);
                    if (entry.isExpired()) {
                        this.cache.expire(oid);
                        entry.expired();
                    } else {
                        this.cache.put(oid, new CacheEntry(entry));
                    }
                }
            }
            return objectLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLock upgrade(OID oid, TransactionContext tx, int timeout) throws ObjectDeletedWaitingForLockException, LockNotGrantedException {
            HashMap hashMap;
            ObjectLock entry = null;
            Object object = this.locks;
            synchronized (object) {
                entry = (ObjectLock)this.locks.get(oid);
                if (entry == null) {
                    throw new ObjectDeletedWaitingForLockException("Lock entry not found. Deleted?");
                }
                if (!entry.hasLock(tx, false)) {
                    throw new IllegalStateException("Transaction does not hold the any lock on " + oid + "!");
                }
                oid = entry.getOID();
                entry.enter();
            }
            try {
                entry.upgrade(tx, timeout);
                object = entry;
                Object var8_7 = null;
                hashMap = this.locks;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                HashMap hashMap2 = this.locks;
                synchronized (hashMap2) {
                    entry.leave();
                }
                throw throwable;
            }
            synchronized (hashMap) {
                entry.leave();
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLock assure(OID oid, TransactionContext tx, boolean write) {
            HashMap hashMap = this.locks;
            synchronized (hashMap) {
                ObjectLock entry = (ObjectLock)this.locks.get(oid);
                if (entry == null) {
                    throw new IllegalStateException("Lock, " + oid + ", doesn't exist or no lock!");
                }
                if (!entry.hasLock(tx, write)) {
                    throw new IllegalStateException("Transaction " + tx + " does not hold the " + (write ? "write" : "read") + " lock: " + entry + "!");
                }
                return entry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLock rename(OID orgoid, OID newoid, TransactionContext tx) throws LockNotGrantedException {
            HashMap hashMap = this.locks;
            synchronized (hashMap) {
                ObjectLock entry = (ObjectLock)this.locks.get(orgoid);
                ObjectLock newentry = (ObjectLock)this.locks.get(newoid);
                if (orgoid == newoid) {
                    throw new LockNotGrantedException("Locks are the same");
                }
                if (entry == null) {
                    throw new LockNotGrantedException("Lock doesn't exist!");
                }
                if (!entry.isExclusivelyOwned(tx)) {
                    throw new LockNotGrantedException("Lock to be renamed is not own exclusively by transaction!");
                }
                if (entry.isEntered()) {
                    throw new LockNotGrantedException("Lock to be renamed is acquired by another transaction!");
                }
                if (newentry != null) {
                    throw new LockNotGrantedException("Lock is already existed for the new oid.");
                }
                entry = (ObjectLock)this.locks.remove(orgoid);
                entry.setOID(newoid);
                this.locks.put(newoid, entry);
                newoid.setDbLock(orgoid.isDbLock());
                newoid.setStamp(orgoid.getStamp());
                return newentry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLock delete(OID oid, TransactionContext tx) {
            HashMap hashMap;
            ObjectLock entry;
            Object object = this.locks;
            synchronized (object) {
                entry = (ObjectLock)this.locks.get(oid);
                if (entry == null) {
                    throw new IllegalStateException("No lock to destroy!");
                }
                entry.enter();
            }
            try {
                entry.delete(tx);
                object = entry;
                Object var7_6 = null;
                hashMap = this.locks;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                HashMap hashMap2 = this.locks;
                synchronized (hashMap2) {
                    entry.leave();
                    if (entry.isDisposable()) {
                        this.cache.put(oid, new CacheEntry(entry));
                        this.locks.remove(oid);
                    }
                }
                throw throwable;
            }
            synchronized (hashMap) {
                entry.leave();
                if (entry.isDisposable()) {
                    this.cache.put(oid, new CacheEntry(entry));
                    this.locks.remove(oid);
                }
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLock release(OID oid, TransactionContext tx) {
            HashMap hashMap;
            ObjectLock entry = null;
            Object object = this.locks;
            synchronized (object) {
                entry = (ObjectLock)this.locks.get(oid);
                if (entry == null) {
                    throw new IllegalStateException("No lock to release! " + oid + " for transaction " + tx);
                }
                entry.enter();
            }
            try {
                entry.release(tx);
                object = entry;
                Object var7_6 = null;
                hashMap = this.locks;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                HashMap hashMap2 = this.locks;
                synchronized (hashMap2) {
                    entry.leave();
                    if (entry.isDisposable()) {
                        this.cache.put(oid, new CacheEntry(entry));
                        if (entry.isExpired()) {
                            this.cache.expire(oid);
                            entry.expired();
                        }
                        this.locks.remove(oid);
                    }
                }
                throw throwable;
            }
            synchronized (hashMap) {
                entry.leave();
                if (entry.isDisposable()) {
                    this.cache.put(oid, new CacheEntry(entry));
                    if (entry.isExpired()) {
                        this.cache.expire(oid);
                        entry.expired();
                    }
                    this.locks.remove(oid);
                }
            }
            return object;
        }

        public boolean isCached(Object oid) {
            return this.cache.containsKey(oid);
        }

        public boolean isLocked(OID oid) {
            return this.locks.containsKey(oid);
        }
    }
}

