/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo;

import org.castor.persist.TransactionContext;
import org.castor.util.Messages;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.spi.Identity;

public class CacheManager {
    private Database db;
    private LockEngine lockEngine;
    private TransactionContext transactionContext;

    public CacheManager(Database db, TransactionContext transactionContext, LockEngine lockEngine) {
        this.db = db;
        this.transactionContext = transactionContext;
        this.lockEngine = lockEngine;
    }

    public boolean isCached(Class cls, Object identity) throws PersistenceException {
        if (this.transactionContext != null && this.transactionContext.isOpen()) {
            return this.transactionContext.isCached(this.lockEngine.getClassMolder(cls), cls, new Identity(identity));
        }
        throw new PersistenceException("isCached() has to be called within an active transaction.");
    }

    public void dumpCache() {
        this.lockEngine.dumpCache();
    }

    public void dumpCache(Class cls) {
        this.lockEngine.dumpCache(cls);
    }

    public void expireCache() {
        this.lockEngine.expireCache();
    }

    public void expireCache(Class type, Object identity) throws PersistenceException {
        this.expireCache(type, new Object[]{identity});
    }

    public void expireCache(Class type, Object[] identity) throws PersistenceException {
        this.testForOpenDatabase();
        ClassMolder molder = this.lockEngine.getClassMolder(type);
        for (int i = 0; i < identity.length; ++i) {
            this.transactionContext.expireCache(molder, new Identity(identity[i]));
        }
    }

    public void expireCache(Class[] type) {
        for (int i = 0; i < type.length; ++i) {
            this.lockEngine.expireCache(type[i]);
        }
    }

    private void testForOpenDatabase() throws PersistenceException {
        if (this.db.isClosed()) {
            throw new PersistenceException(Messages.message("jdo.dbClosed"));
        }
    }
}

