/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.exolab.castor.dsml.Consumer;
import org.exolab.castor.dsml.ImportDescriptor;
import org.exolab.castor.dsml.ImportExportException;
import org.exolab.castor.dsml.SearchDescriptor;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public abstract class Exporter {
    private Configuration _config = LocalConfiguration.getInstance();
    private SearchDescriptor _searchDesc;
    private ImportDescriptor _importDesc;

    public void export(OutputStream output, boolean serverSchema, boolean importPolicy) throws ImportExportException {
        try {
            this.export(this._config.getSerializer(output), serverSchema, importPolicy);
        }
        catch (IOException except) {
            throw new ImportExportException(except);
        }
    }

    public void export(Writer output, boolean serverSchema, boolean importPolicy) throws ImportExportException {
        try {
            this.export(this._config.getSerializer(output), serverSchema, importPolicy);
        }
        catch (IOException except) {
            throw new ImportExportException(except);
        }
    }

    public abstract void export(DocumentHandler var1, boolean var2, boolean var3) throws ImportExportException;

    public void setSearchDescriptor(SearchDescriptor searchDesc) {
        this._searchDesc = searchDesc;
    }

    public SearchDescriptor getSearchDescriptor() {
        return this._searchDesc;
    }

    public void setImportDescriptor(ImportDescriptor importDesc) {
        this._importDesc = importDesc;
    }

    public ImportDescriptor getImportDescriptor() {
        return this._importDesc;
    }

    public void readSearchDescriptor(InputStream input) throws IOException, SAXException {
        this.readSearchDescriptor(this._config.getParser(), new InputSource(input));
    }

    public void readSearchDescriptor(Reader input) throws IOException, SAXException {
        this.readSearchDescriptor(this._config.getParser(), new InputSource(input));
    }

    protected void readSearchDescriptor(Parser parser, InputSource input) throws IOException, SAXException {
        SearchDescriptor desc = new SearchDescriptor();
        parser.setDocumentHandler(desc);
        parser.parse(input);
        this.setSearchDescriptor(desc);
    }

    protected abstract Consumer createConsumer();
}

