/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.hashbelt;

import java.util.Iterator;
import java.util.Map;
import org.castor.cache.hashbelt.AbstractHashbelt;

public final class FIFOHashbelt
extends AbstractHashbelt {
    public static final String TYPE = "fifo";

    public String getType() {
        return TYPE;
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Object result = null;
        try {
            this.lock().readLock().acquire();
        }
        catch (InterruptedException ex) {
            return null;
        }
        try {
            result = this.getObjectFromCache(key);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.lock().readLock().release();
        }
        return result;
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        Object result = null;
        try {
            this.lock().writeLock().acquire();
        }
        catch (InterruptedException ex) {
            return null;
        }
        try {
            result = this.putObjectIntoCache(key, value);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.lock().writeLock().release();
        }
        return result;
    }

    public Object remove(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Object result = null;
        try {
            this.lock().writeLock().acquire();
        }
        catch (InterruptedException ex) {
            return null;
        }
        try {
            result = this.removeObjectFromCache(key);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.lock().writeLock().release();
        }
        return result;
    }

    public void putAll(Map map) {
        if (map.containsKey(null)) {
            throw new NullPointerException("key");
        }
        if (map.containsValue(null)) {
            throw new NullPointerException("value");
        }
        Iterator iter = map.entrySet().iterator();
        try {
            this.lock().writeLock().acquire();
        }
        catch (InterruptedException ex) {
            return;
        }
        try {
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.putObjectIntoCache(entry.getKey(), entry.getValue());
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.lock().writeLock().release();
        }
    }
}

