/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.Cache;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.CacheFactory;

public abstract class AbstractCacheFactory
implements CacheFactory {
    private static final Log LOG = LogFactory.getLog((Class)AbstractCacheFactory.class);

    public final Cache getCache(ClassLoader classLoader) throws CacheAcquireException {
        ClassLoader loader = classLoader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        Cache cache = null;
        try {
            cache = (Cache)loader.loadClass(this.getCacheClassName()).newInstance();
        }
        catch (Exception e) {
            String msg = "Error creating cache instance of: " + this.getCacheClassName();
            LOG.error((Object)msg, (Throwable)e);
            throw new CacheAcquireException(msg, e);
        }
        return cache;
    }

    public void shutdown() {
    }
}

