/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.LogConverter;
import javax.measure.converter.UnitConverter;

public final class ExpConverter
extends UnitConverter {
    private final double _base;
    private final double _logBase;
    private static final long serialVersionUID = 1L;

    public ExpConverter(double base) {
        this._base = base;
        this._logBase = Math.log(base);
    }

    public double getBase() {
        return this._base;
    }

    public UnitConverter inverse() {
        return new LogConverter(this._base);
    }

    public final String toString() {
        return "ExpConverter(" + this._base + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExpConverter)) {
            return false;
        }
        ExpConverter that = (ExpConverter)obj;
        return this._base == that._base;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this._base);
        return (int)(bits ^ bits >>> 32);
    }

    public double convert(double amount) {
        return Math.exp(this._logBase * amount);
    }

    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return BigDecimal.valueOf(this.convert(value.doubleValue()));
    }
}

