/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.MeridianArcBased;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class CassiniSoldner
extends MeridianArcBased {
    private static final long serialVersionUID = 8306467537772990906L;
    private static final byte HYPERBOLIC = 1;
    private static final byte VANUA = 2;
    private static final double VANUA_LATITUDE = -0.28361600344907856;
    private final byte variant;
    private final double M0;

    private static byte getVariant(OperationMethod operationMethod) {
        if (CassiniSoldner.identMatch(operationMethod, "(?i).*\\bHyperbolic\\b.*", "9833")) {
            return 1;
        }
        return 0;
    }

    public CassiniSoldner(OperationMethod operationMethod, Parameters parameters) {
        this(CassiniSoldner.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.CassiniSoldner.LONGITUDE_OF_ORIGIN);
        enumMap.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, org.apache.sis.internal.referencing.provider.CassiniSoldner.SCALE_FACTOR);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.internal.referencing.provider.CassiniSoldner.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.internal.referencing.provider.CassiniSoldner.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, CassiniSoldner.getVariant(operationMethod));
    }

    CassiniSoldner(Initializer initializer) {
        super(initializer);
        double d = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.CassiniSoldner.LATITUDE_OF_ORIGIN));
        this.M0 = this.distance(d, Math.sin(d), Math.cos(d));
        if (initializer.variant == 0) {
            MatrixSIS matrixSIS = this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
            matrixSIS.convertBefore(1, null, -this.distance(d, Math.sin(d), Math.cos(d)));
        } else if (Math.abs(d - -0.28361600344907856) <= 1.5706706731410455E-9) {
            this.variant = (byte)2;
            return;
        }
        this.variant = initializer.variant;
    }

    CassiniSoldner(CassiniSoldner cassiniSoldner) {
        super(cassiniSoldner);
        this.variant = cassiniSoldner.variant;
        this.M0 = cassiniSoldner.M0;
    }

    @Override
    final String[] getInternalParameterNames() {
        if (this.variant != 0) {
            return new String[]{"M\u2080"};
        }
        return super.getInternalParameterNames();
    }

    @Override
    final double[] getInternalParameterValues() {
        if (this.variant != 0) {
            return new double[]{this.M0};
        }
        return super.getInternalParameterValues();
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        CassiniSoldner cassiniSoldner = this;
        if (this.eccentricity == 0.0 && this.variant == 0) {
            cassiniSoldner = new Spherical(this);
        }
        return this.context.completeTransform(mathTransformFactory, cassiniSoldner);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d;
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double d6 = d5 * d5;
        double d7 = d4 * d4;
        double d8 = d5 / d4;
        double d9 = d8 * d8;
        double d10 = d2 * d4;
        double d11 = d10 * d10;
        double d12 = d11 * d10;
        double d13 = 1.0 - d6 * this.eccentricitySquared;
        double d14 = d7 * this.eccentricitySquared / (1.0 - this.eccentricitySquared);
        double d15 = d9 - 8.0 * (d14 + 1.0);
        double d16 = ((5.0 - d9) / 6.0 + d14) * d11;
        double d17 = Math.sqrt(d13);
        if (dArray2 != null) {
            dArray2[n2] = (d10 - d9 * d12 / 6.0 + d15 * d9 * (d12 * d11) / 120.0) / d17;
            dArray2[n2 + 1] = this.distance(d3, d5, d4) + d8 * d11 * (0.5 + d16 / 4.0) / d17;
            if (this.variant != 0) {
                d = dArray2[n2 + 1] - this.M0;
                dArray2[n2 + 1] = d - d * d * d / (6.0 * (1.0 - this.eccentricitySquared) / (d13 * d13));
            }
        }
        if (!bl) {
            return null;
        }
        if (this.variant != 0) {
            throw new ProjectionException(Resources.format((short)2));
        }
        d = d2 * d2;
        double d18 = d2 * d5;
        double d19 = d18 * d18;
        double d20 = d7 * this.eccentricitySquared / d13;
        double d21 = d11 * d15 / 60.0 - 0.3333333333333333;
        double d22 = d19 * (d15 * d11 / 24.0 - 0.5);
        return new Matrix2(d4 / d17 * (d22 + 1.0), d18 * (d * d21 - d22 + d19 * (d + 8.0 * d14 * d11) / 60.0 + (d20 * (d19 * d21 / 2.0 + 1.0) - 1.0) / d17), d18 * d4 / d17 * (d16 + 1.0), d19 / d17 * ((d16 / 4.0 + 0.5) * (d20 + 1.0 / d6) - (d16 + 1.0 + d11 * d14 / 2.0 + d / 12.0)) + this.dM_d\u03c6(d6));
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = dArray[n];
        double d6 = dArray[n + 1];
        if (this.variant != 0) {
            if (this.variant != 2) {
                throw new ProjectionException(Errors.format((short)170, "\u03c6\u2080\u226016\u00b015\u2032S"));
            }
            d4 = Math.sin(-0.28361600344907856 + d6 * 1.0055298331853355);
            d3 = 1.0 - this.eccentricitySquared * (d4 * d4);
            d2 = 6.0 * (1.0 - this.eccentricitySquared) / (d3 * d3);
            d = d6 + d6 * d6 * d6 / d2;
            d6 += d * d * d / d2 + this.M0;
        }
        d4 = this.latitude(d6);
        d3 = Math.sin(d4);
        d2 = Math.cos(d4);
        d = d3 / d2;
        double d7 = 1.0 - this.eccentricitySquared * (d3 * d3);
        double d8 = (1.0 - this.eccentricitySquared) / d7;
        double d9 = d5 * Math.sqrt(d7);
        double d10 = d9 * d9;
        double d11 = d10 * d10;
        double d12 = d * d;
        dArray2[n2] = (d9 - d12 * (d10 * d9) / 3.0 + (1.0 + 3.0 * d12) * d12 * (d11 * d9) / 15.0) / d2;
        dArray2[n2 + 1] = d4 - d / d8 * (d10 / 2.0 - (1.0 + 3.0 * d12) * d11 / 24.0);
    }

    static final class Spherical
    extends CassiniSoldner {
        private static final long serialVersionUID = -8131887916538379858L;

        protected Spherical(CassiniSoldner cassiniSoldner) {
            super(cassiniSoldner);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.sin(d);
            double d4 = Math.cos(d);
            double d5 = Math.sin(d2);
            double d6 = Math.cos(d2);
            double d7 = d5 / d6;
            if (dArray2 != null) {
                dArray2[n2] = Math.asin(d6 * d3);
                dArray2[n2 + 1] = Math.atan2(d7, d4);
            }
            if (!bl) {
                return null;
            }
            double d8 = d6 * d6;
            double d9 = d3 * d3;
            double d10 = Math.sqrt(1.0 - d9 * d8);
            double d11 = d7 * d7 + d4 * d4;
            return new Matrix2(d4 * d6 / d10, -d3 * d5 / d10, d3 * d7 / d11, d4 / d8 / d11);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            dArray2[n2] = Math.atan2(Math.tan(d), Math.cos(d2));
            dArray2[n2 + 1] = Math.asin(Math.sin(d2) * Math.cos(d));
        }
    }
}

