/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.cs.AxisDirection;

final class Codes {
    final int directions;
    final short unit;
    final short epsg;
    private static final Map<Codes, Codes> EPSG = new HashMap<Codes, Codes>(31);

    private Codes(int n, short s, short s2) {
        this.directions = n;
        this.unit = s;
        this.epsg = s2;
    }

    private static int pack(AxisDirection[] axisDirectionArray) {
        int n = 0;
        int n2 = axisDirectionArray.length;
        if (n2 <= 4) {
            while (--n2 >= 0) {
                int n3 = axisDirectionArray[n2].ordinal();
                if (n3 <= 0 || n3 > 127) {
                    return 0;
                }
                n = n << 8 | n3;
            }
        }
        return n;
    }

    static short lookup(Unit<?> unit, AxisDirection[] axisDirectionArray) {
        int n;
        Integer n2 = Units.getEpsgCode(unit, true);
        if (n2 != null && (n = Codes.pack(axisDirectionArray)) != 0) {
            Codes codes = new Codes(n, n2.shortValue(), 0);
            if ((codes = EPSG.get(codes)) != null) {
                return codes.epsg;
            }
        }
        return 0;
    }

    public int hashCode() {
        return this.directions + this.unit;
    }

    public boolean equals(Object object) {
        if (object instanceof Codes) {
            Codes codes = (Codes)object;
            return this.directions == codes.directions && this.unit == codes.unit;
        }
        return false;
    }

    static {
        Object[] objectArray = new AxisDirection[]{AxisDirection.EAST, AxisDirection.NORTH};
        int n = AxisDirection.UP.ordinal() << 16;
        int n2 = Codes.pack((AxisDirection[])objectArray);
        short s = 9001;
        int n3 = 0;
        block19: while (true) {
            int n4;
            short s2 = 0;
            switch (n3) {
                case 0: {
                    n4 = 4400;
                    break;
                }
                case 1: {
                    n4 = 1039;
                    s = 9002;
                    break;
                }
                case 2: {
                    n4 = 4497;
                    s = 9003;
                    break;
                }
                case 3: {
                    n4 = 4403;
                    s = 9005;
                    break;
                }
                case 4: {
                    n4 = 6424;
                    s2 = 6426;
                    s = 9122;
                    break;
                }
                case 5: {
                    n4 = 6425;
                    s2 = 6427;
                    s = 9105;
                    break;
                }
                case 6: {
                    n4 = 6429;
                    s2 = 6431;
                    s = 9101;
                    break;
                }
                case 7: {
                    ArraysExt.swap(objectArray, 0, 1);
                    n2 = Codes.pack((AxisDirection[])objectArray);
                    n4 = 4500;
                    s = 9001;
                    break;
                }
                case 8: {
                    n4 = 1029;
                    s = 9002;
                    break;
                }
                case 9: {
                    n4 = 4502;
                    s = 9005;
                    break;
                }
                case 10: {
                    n4 = 6422;
                    s2 = 6423;
                    s = 9122;
                    break;
                }
                case 11: {
                    n4 = 6403;
                    s2 = 6421;
                    s = 9105;
                    break;
                }
                case 12: {
                    n4 = 6428;
                    s2 = 6430;
                    s = 9101;
                    break;
                }
                case 13: {
                    objectArray[1] = AxisDirection.WEST;
                    n2 = Codes.pack((AxisDirection[])objectArray);
                    n4 = 4501;
                    s = 9001;
                    break;
                }
                case 14: {
                    ArraysExt.swap(objectArray, 0, 1);
                    n2 = Codes.pack((AxisDirection[])objectArray);
                    n4 = 4491;
                    break;
                }
                case 15: {
                    objectArray[1] = AxisDirection.SOUTH;
                    n2 = Codes.pack((AxisDirection[])objectArray);
                    n4 = 6503;
                    break;
                }
                case 16: {
                    ArraysExt.swap(objectArray, 0, 1);
                    n2 = Codes.pack((AxisDirection[])objectArray);
                    n4 = 6501;
                    break;
                }
                default: {
                    break block19;
                }
            }
            Codes codes = new Codes(n2, s, (short)n4);
            if (EPSG.put(codes, codes) != null) {
                throw new AssertionError(codes.epsg);
            }
            if (s2 != 0 && EPSG.put(codes = new Codes(n2 | n, s, s2), codes) != null) {
                throw new AssertionError(codes.epsg);
            }
            ++n3;
        }
    }
}

