/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import javax.measure.quantity.Angle;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.DatumShiftGridCompressed;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.referencing.provider.DatumShiftGridLoader;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlTransient
public final class NADCON
extends AbstractProvider {
    private static final long serialVersionUID = -4707304160205218546L;
    private static final ParameterDescriptor<Path> LATITUDE;
    private static final ParameterDescriptor<Path> LONGITUDE;
    private static final ParameterDescriptorGroup PARAMETERS;

    public NADCON() {
        super(2, 2, PARAMETERS);
    }

    public Class<Transformation> getOperationType() {
        return Transformation.class;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException, FactoryException {
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        return DatumShiftGridFile.createGeodeticTransformation(NADCON.class, mathTransformFactory, NADCON.getOrLoad(parameters.getMandatoryValue(LATITUDE), parameters.getMandatoryValue(LONGITUDE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatumShiftGridFile<Angle, Angle> getOrLoad(Path path, Path path2) throws FactoryException {
        DatumShiftGridFile<Object, Object> datumShiftGridFile;
        block18: {
            Path path3;
            Path path4 = DataDirectory.DATUM_CHANGES.resolve(path).toAbsolutePath();
            AbstractMap.SimpleImmutableEntry<Path, Path> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Path, Path>(path4, path3 = DataDirectory.DATUM_CHANGES.resolve(path2).toAbsolutePath());
            datumShiftGridFile = DatumShiftGridFile.CACHE.peek(simpleImmutableEntry);
            if (datumShiftGridFile == null) {
                Cache.Handler<DatumShiftGridFile<?, ?>> handler = DatumShiftGridFile.CACHE.lock(simpleImmutableEntry);
                try {
                    Loader loader;
                    datumShiftGridFile = handler.peek();
                    if (datumShiftGridFile != null) break block18;
                    Path path5 = path;
                    try {
                        ByteBuffer byteBuffer = ByteBuffer.allocate(4096).order(ByteOrder.LITTLE_ENDIAN);
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path4, new OpenOption[0]);){
                            DatumShiftGridLoader.startLoading(NADCON.class, CharSequences.commonPrefix(path.toString(), path2.toString()).toString() + '\u2026');
                            loader = new Loader(seekableByteChannel, byteBuffer, path5);
                            loader.readGrid(floatBuffer, null, path2);
                        }
                        byteBuffer.clear();
                        path5 = path2;
                        seekableByteChannel = Files.newByteChannel(path3, new OpenOption[0]);
                        try {
                            new Loader(seekableByteChannel, byteBuffer, path5).readGrid(floatBuffer, loader, null);
                        }
                        finally {
                            if (seekableByteChannel != null) {
                                seekableByteChannel.close();
                            }
                        }
                    }
                    catch (IOException | RuntimeException | NoninvertibleTransformException throwable) {
                        throw DatumShiftGridLoader.canNotLoad("NADCON", path5, (Exception)throwable);
                    }
                    datumShiftGridFile = DatumShiftGridCompressed.compress(loader.grid, null, loader.grid.accuracy);
                    datumShiftGridFile = datumShiftGridFile.useSharedData();
                }
                finally {
                    handler.putAndUnlock(datumShiftGridFile);
                }
            }
        }
        return datumShiftGridFile.castTo(Angle.class, Angle.class);
    }

    static {
        ParameterBuilder parameterBuilder = NADCON.builder();
        LATITUDE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8657")).addName("Latitude difference file")).create(Path.class, Paths.get("conus.las", new String[0]));
        LONGITUDE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8658")).addName("Longitude difference file")).create(Path.class, Paths.get("conus.los", new String[0]));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("9613")).addName("NADCON")).createGroup(new GeneralParameterDescriptor[]{LATITUDE, LONGITUDE});
    }

    private static final class Loader
    extends DatumShiftGridLoader {
        private static final int DESCRIPTION_LENGTH = 64;
        private static final String NADCON = "NADCON";
        private final float x0;
        private final float y0;
        private final float \u0394x;
        private final float \u0394y;
        private final int nx;
        private final int ny;
        private final int nz;
        private final StringBuilder ascii;
        DatumShiftGridFile.Float<Angle, Angle> grid;

        Loader(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, Path path) throws IOException, FactoryException {
            super(readableByteChannel, byteBuffer, path);
            this.ensureBufferContains(144);
            for (int i = 0; i < NADCON.length(); ++i) {
                if (byteBuffer.get() == NADCON.charAt(i)) continue;
                throw this.unexpectedFormat();
            }
            if (Loader.isASCII(byteBuffer)) {
                this.ascii = new StringBuilder();
                this.nx = Integer.parseInt(this.nextWord());
                this.ny = Integer.parseInt(this.nextWord());
                this.nz = Integer.parseInt(this.nextWord());
                this.x0 = Float.parseFloat(this.nextWord());
                this.\u0394x = Float.parseFloat(this.nextWord());
                this.y0 = Float.parseFloat(this.nextWord());
                this.\u0394y = Float.parseFloat(this.nextWord());
                Float.parseFloat(this.nextWord());
            } else {
                this.ascii = null;
                byteBuffer.position(64);
                this.nx = byteBuffer.getInt();
                this.ny = byteBuffer.getInt();
                this.nz = byteBuffer.getInt();
                this.x0 = byteBuffer.getFloat();
                this.\u0394x = byteBuffer.getFloat();
                this.y0 = byteBuffer.getFloat();
                this.\u0394y = byteBuffer.getFloat();
            }
            if (this.nx < 8 || this.ny < 1 || this.nz < 1 || !(this.\u0394x > 0.0f) || !(this.\u0394y > 0.0f) || Float.isNaN(this.x0) || Float.isNaN(this.y0)) {
                throw this.unexpectedFormat();
            }
            if (this.ascii == null) {
                this.skip((this.nx + 1) * 4 - byteBuffer.position());
            }
        }

        private static boolean isASCII(ByteBuffer byteBuffer) {
            int n = 0;
            while (byteBuffer.hasRemaining()) {
                char c = (char)byteBuffer.get();
                if (c == ' ' || c >= '+' && c <= '9' && c != ',' && c != '/') continue;
                if (c == '\r' || c == '\n') {
                    if (n != 0) continue;
                    n = byteBuffer.position();
                    continue;
                }
                if (n == 0 && c >= ' ' & c <= '~') continue;
                return false;
            }
            if (n == 0) {
                return false;
            }
            byteBuffer.position(n);
            return true;
        }

        private String nextWord() throws IOException {
            char c;
            do {
                this.ensureBufferContains(1);
            } while (Character.isWhitespace(c = (char)this.buffer.get()));
            this.ascii.setLength(0);
            do {
                this.ascii.append(c);
                this.ensureBufferContains(1);
            } while (!Character.isWhitespace(c = (char)this.buffer.get()));
            return this.ascii.toString();
        }

        private FactoryException unexpectedFormat() {
            return new FactoryException(Errors.format((short)139, NADCON, this.file));
        }

        final void readGrid(FloatBuffer floatBuffer, Loader loader, Path path) throws IOException, FactoryException, NoninvertibleTransformException {
            double d;
            int n;
            if (loader == null) {
                n = 1;
                d = 3600.0 * (double)this.\u0394y;
                this.grid = new DatumShiftGridFile.Float<Angle, Angle>(2, Units.DEGREE, Units.DEGREE, true, (double)this.x0, (double)this.y0, (double)this.\u0394x, this.\u0394y, this.nx, this.ny, PARAMETERS, this.file, path);
                this.grid.accuracy = 2.777777777777778E-8;
            } else {
                if (this.x0 != loader.x0 || this.\u0394x != loader.\u0394x || this.nx != loader.nx || this.y0 != loader.y0 || this.\u0394y != loader.\u0394y || this.ny != loader.ny || this.nz != loader.nz) {
                    throw new FactoryException(Errors.format((short)82, loader.file.getFileName(), this.file.getFileName()));
                }
                n = 0;
                d = -3600.0 * (double)this.\u0394x;
                this.grid = loader.grid;
            }
            float[] fArray = this.grid.offsets[n];
            if (this.ascii != null) {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = (float)(Double.parseDouble(this.nextWord()) / d);
                }
            } else {
                int n2;
                int n3;
                this.syncView(floatBuffer);
                int n4 = 0;
                for (n2 = 0; n2 < fArray.length; n2 += n3) {
                    int n5;
                    if (n4 == 0) {
                        if (!floatBuffer.hasRemaining()) {
                            this.fillBuffer(floatBuffer);
                        }
                        if (floatBuffer.get() != 0.0f) {
                            throw this.unexpectedFormat();
                        }
                        n4 = this.nx;
                    }
                    if ((n5 = floatBuffer.remaining()) == 0) {
                        this.fillBuffer(floatBuffer);
                        n5 = floatBuffer.remaining();
                    }
                    n3 = Math.min(n4, n5);
                    floatBuffer.get(fArray, n2, n3);
                    n4 -= n3;
                }
                n2 = 0;
                while (n2 < fArray.length) {
                    int n6 = n2++;
                    fArray[n6] = (float)((double)fArray[n6] / d);
                }
            }
        }

        private void fillBuffer(FloatBuffer floatBuffer) throws IOException {
            this.buffer.position(floatBuffer.position() * 4).limit(floatBuffer.limit() * 4);
            this.ensureBufferContains(4);
            this.syncView(floatBuffer);
        }

        private void syncView(FloatBuffer floatBuffer) {
            if (this.buffer.position() % 4 != 0) {
                this.buffer.compact();
            }
            floatBuffer.limit(this.buffer.limit() / 4).position(this.buffer.position() / 4);
        }
    }
}

