/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.methods;

import okhttp3.ResponseBody;
import org.nuxeo.client.objects.directory.Directories;
import org.nuxeo.client.objects.directory.DirectoryEntries;
import org.nuxeo.client.objects.directory.DirectoryEntry;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface DirectoryManagerAPI {
    @GET(value="directory")
    public Call<Directories> fetchDirectories();

    @GET(value="directory/{directoryName}")
    public Call<DirectoryEntries> fetchDirectoryEntries(@Path(value="directoryName") String var1);

    @GET(value="directory/{directoryName}")
    public Call<DirectoryEntries> fetchDirectoryEntries(@Path(value="directoryName") String var1, @Query(value="currentPageIndex") String var2, @Query(value="pageSize") String var3, @Query(value="maxResults") String var4, @Query(value="sortBy") String var5, @Query(value="sortOrder") String var6);

    @POST(value="directory/{directoryName}")
    public Call<DirectoryEntry> createDirectoryEntry(@Path(value="directoryName") String var1, @Body DirectoryEntry var2);

    @GET(value="directory/{directoryName}/{entryId}")
    public Call<DirectoryEntry> fetchDirectoryEntry(@Path(value="directoryName") String var1, @Path(value="entryId") String var2);

    @PUT(value="directory/{directoryName}/{entryId}")
    public Call<DirectoryEntry> updateDirectoryEntry(@Path(value="directoryName") String var1, @Path(value="entryId") String var2, @Body DirectoryEntry var3);

    @DELETE(value="directory/{directoryName}/{entryId}")
    public Call<ResponseBody> deleteDirectoryEntry(@Path(value="directoryName") String var1, @Path(value="entryId") String var2);
}

