/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov.atoms.canon;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialReader;
import com.drew.lang.StreamReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.mov.QuickTimeDirectory;
import com.drew.metadata.mov.atoms.Atom;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;

public class CanonThumbnailAtom
extends Atom {
    private String dateTime;

    public CanonThumbnailAtom(SequentialReader reader) throws IOException {
        super(reader);
        this.readCNDA(reader);
    }

    private void readCNDA(SequentialReader reader) throws IOException {
        if (this.type.compareTo("CNDA") == 0) {
            JpegSegmentData segmentData;
            ExifReader exifReader = new ExifReader();
            ByteArrayInputStream exifStream = new ByteArrayInputStream(reader.getBytes((int)this.size));
            HashSet<JpegSegmentType> segmentTypes = new HashSet<JpegSegmentType>();
            for (JpegSegmentType type : exifReader.getSegmentTypes()) {
                segmentTypes.add(type);
            }
            try {
                segmentData = JpegSegmentReader.readSegments(new StreamReader(exifStream), segmentTypes);
            }
            catch (JpegProcessingException e) {
                return;
            }
            Metadata metadata = new Metadata();
            for (JpegSegmentType segmentType : exifReader.getSegmentTypes()) {
                exifReader.readJpegSegments(segmentData.getSegments(segmentType), metadata, segmentType);
            }
            ExifIFD0Directory directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            if (directory != null) {
                for (Tag tag : directory.getTags()) {
                    if (tag.getTagType() != 306) continue;
                    this.dateTime = tag.getDescription();
                }
            }
        }
    }

    public void addMetadata(QuickTimeDirectory directory) {
        directory.setString(8192, this.dateTime);
    }
}

