/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.LeafNodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.SignatureObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BinaryItem;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ZipHeader;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking.AbstractChunking;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitConverter;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitReader;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitWriter;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.ByteUtil;

public class ZipFilesChunking
extends AbstractChunking {
    public ZipFilesChunking(byte[] fileContent) {
        super(fileContent);
    }

    @Override
    public List<LeafNodeObject> chunking() throws TikaException, IOException {
        ArrayList<LeafNodeObject> list = new ArrayList<LeafNodeObject>();
        LeafNodeObject.IntermediateNodeObjectBuilder builder = new LeafNodeObject.IntermediateNodeObjectBuilder();
        int index = 0;
        while (ZipHeader.isFileHeader(this.fileContent, index)) {
            int compressedSize;
            AtomicReference<byte[]> dataFileSignatureBytes = new AtomicReference<byte[]>();
            byte[] header = this.analyzeFileHeader(this.fileContent, index, dataFileSignatureBytes);
            int headerLength = header.length;
            if (headerLength + (compressedSize = (int)this.getCompressedSize(dataFileSignatureBytes.get())) <= 4096) {
                list.add(builder.Build(Arrays.copyOfRange(this.fileContent, index, headerLength + compressedSize), this.getSingleChunkSignature(header, dataFileSignatureBytes.get())));
                index += (headerLength += compressedSize);
                continue;
            }
            list.add(builder.Build(header, this.getSHA1Signature(header)));
            byte[] dataFile = Arrays.copyOfRange(this.fileContent, index += headerLength, compressedSize);
            if (dataFile.length <= 0x100000) {
                list.add(builder.Build(dataFile, this.getDataFileSignature(dataFileSignatureBytes.get())));
            } else {
                list.addAll(this.getSubChunkList(dataFile));
            }
            index += compressedSize;
        }
        if (0 == index) {
            return null;
        }
        byte[] finalRes = Arrays.copyOfRange(this.fileContent, index, this.fileContent.length - index);
        if (finalRes.length > 0x100000) {
            throw new TikaException("If the final chunk is larger than 1MB, the signature method is not implemented.");
        }
        list.add(builder.Build(finalRes, this.getSHA1Signature(finalRes)));
        return list;
    }

    private List<LeafNodeObject> getSubChunkList(byte[] chunkData) {
        int length;
        ArrayList<LeafNodeObject> subChunkList = new ArrayList<LeafNodeObject>();
        for (int index = 0; index < chunkData.length; index += length) {
            length = chunkData.length - index < 0x100000 ? chunkData.length - index : 0x100000;
            byte[] temp = Arrays.copyOfRange(chunkData, index, length);
            subChunkList.add(new LeafNodeObject.IntermediateNodeObjectBuilder().Build(temp, this.getSubChunkSignature()));
        }
        return subChunkList;
    }

    private byte[] analyzeFileHeader(byte[] content, int index, AtomicReference<byte[]> dataFileSignature) throws IOException {
        int crc32 = BitConverter.toInt32(content, index + 14);
        int compressedSize = BitConverter.toInt32(content, index + 18);
        int uncompressedSize = BitConverter.toInt32(content, index + 22);
        short fileNameLength = BitConverter.toInt16(content, index + 26);
        short extraFileldLength = BitConverter.toInt16(content, index + 28);
        int headerLength = 30 + fileNameLength + extraFileldLength;
        BitWriter writer = new BitWriter(20);
        writer.appendInit32(crc32, 32);
        writer.appendUInt64(compressedSize, 64);
        writer.appendUInt64(uncompressedSize, 64);
        dataFileSignature.set(writer.getBytes());
        return Arrays.copyOfRange(content, index, headerLength);
    }

    private long getCompressedSize(byte[] dataFileSignature) throws IOException {
        BitReader reader = new BitReader(dataFileSignature, 0);
        reader.readUInt32(32);
        return reader.readUInt64(64);
    }

    private SignatureObject getSingleChunkSignature(byte[] header, byte[] dataFile) {
        byte[] headerSignature = DigestUtils.sha1((byte[])header);
        ArrayList<Byte> singleSignature = new ArrayList<Byte>();
        ByteUtil.appendByteArrayToListOfByte(singleSignature, headerSignature);
        ByteUtil.appendByteArrayToListOfByte(singleSignature, dataFile);
        SignatureObject signature = new SignatureObject();
        signature.signatureData = new BinaryItem(singleSignature);
        return signature;
    }

    private SignatureObject getSHA1Signature(byte[] array) {
        byte[] temp = DigestUtils.sha1((byte[])array);
        SignatureObject signature = new SignatureObject();
        signature.signatureData = new BinaryItem(ByteUtil.toListOfByte(temp));
        return signature;
    }

    private SignatureObject getDataFileSignature(byte[] array) {
        SignatureObject signature = new SignatureObject();
        signature.signatureData = new BinaryItem(ByteUtil.toListOfByte(array));
        return signature;
    }

    private SignatureObject getSubChunkSignature() {
        throw new NotImplementedException("The Get sub chunk signature method is not implemented.");
    }
}

