/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.erasurecode;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;

@InterfaceAudience.Private
public class StripedReconstructionInfo {
    private final ExtendedBlock blockGroup;
    private final ErasureCodingPolicy ecPolicy;
    private final byte[] liveIndices;
    private final DatanodeInfo[] sources;
    private final byte[] targetIndices;
    private final DatanodeInfo[] targets;
    private final StorageType[] targetStorageTypes;
    private final String[] targetStorageIds;
    private final byte[] excludeReconstructedIndices;

    public StripedReconstructionInfo(ExtendedBlock blockGroup, ErasureCodingPolicy ecPolicy, byte[] liveIndices, DatanodeInfo[] sources, byte[] targetIndices) {
        this(blockGroup, ecPolicy, liveIndices, sources, targetIndices, null, null, null, new byte[0]);
    }

    StripedReconstructionInfo(ExtendedBlock blockGroup, ErasureCodingPolicy ecPolicy, byte[] liveIndices, DatanodeInfo[] sources, DatanodeInfo[] targets, StorageType[] targetStorageTypes, String[] targetStorageIds, byte[] excludeReconstructedIndices) {
        this(blockGroup, ecPolicy, liveIndices, sources, null, targets, targetStorageTypes, targetStorageIds, excludeReconstructedIndices);
    }

    private StripedReconstructionInfo(ExtendedBlock blockGroup, ErasureCodingPolicy ecPolicy, byte[] liveIndices, DatanodeInfo[] sources, byte[] targetIndices, DatanodeInfo[] targets, StorageType[] targetStorageTypes, String[] targetStorageIds, byte[] excludeReconstructedIndices) {
        this.blockGroup = blockGroup;
        this.ecPolicy = ecPolicy;
        this.liveIndices = liveIndices;
        this.sources = sources;
        this.targetIndices = targetIndices;
        this.targets = targets;
        this.targetStorageTypes = targetStorageTypes;
        this.targetStorageIds = targetStorageIds;
        this.excludeReconstructedIndices = excludeReconstructedIndices;
    }

    ExtendedBlock getBlockGroup() {
        return this.blockGroup;
    }

    ErasureCodingPolicy getEcPolicy() {
        return this.ecPolicy;
    }

    byte[] getLiveIndices() {
        return this.liveIndices;
    }

    DatanodeInfo[] getSources() {
        return this.sources;
    }

    byte[] getTargetIndices() {
        return this.targetIndices;
    }

    DatanodeInfo[] getTargets() {
        return this.targets;
    }

    StorageType[] getTargetStorageTypes() {
        return this.targetStorageTypes;
    }

    String[] getTargetStorageIds() {
        return this.targetStorageIds;
    }

    byte[] getExcludeReconstructedIndices() {
        return this.excludeReconstructedIndices;
    }
}

