/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.Namespaces;
import org.apache.sis.xml.TransformVersion;
import org.apache.sis.xml.TransformedEvent;
import org.apache.sis.xml.Transformer;
import org.apache.sis.xml.TransformingNamespaces;

final class TransformingWriter
extends Transformer
implements XMLEventWriter {
    private static final String FILENAME = "RenameOnExport.lst";
    private static final Map<String, Map<String, String>> NAMESPACES = TransformingWriter.load(true, "RenameOnExport.lst", Collections.emptySet(), 60);
    private static final Map<QName, Set<QName>> ELEMENTS_TO_REORDER;
    private final XMLEventWriter out;
    private final Map<String, Namespace> uniqueNamespaces;
    private boolean isDeferring;
    private final Queue<Object> deferred;
    private Set<QName> toSkip;
    private QName subtreeRootName;
    private int subtreeNesting;

    TransformingWriter(XMLEventWriter xMLEventWriter, TransformVersion transformVersion) {
        super(transformVersion);
        this.out = xMLEventWriter;
        this.uniqueNamespaces = new LinkedHashMap<String, Namespace>();
        this.deferred = new ArrayDeque<Object>();
    }

    @Override
    final Map<String, Map<String, String>> renamingMap(String string) {
        return NAMESPACES;
    }

    @Override
    final String relocate(String string) {
        return this.version.exportNS(string);
    }

    @Override
    final String prefixReplacement(String string, String string2) throws XMLStreamException {
        String string3 = this.out.getPrefix(string2);
        if (string3 == null) {
            string3 = Namespaces.getPreferredPrefix(string2, string);
            this.out.setPrefix(string3, string2);
        }
        return string3;
    }

    private Namespace exportIfNew(Namespace namespace) {
        this.notify(namespace);
        String string2 = namespace.getNamespaceURI();
        if (string2 != null && !string2.isEmpty()) {
            String string3 = TransformingWriter.removeTrailingSlash(string2);
            String string4 = this.relocate(string3);
            if (string4 != string3) {
                return this.uniqueNamespaces.computeIfAbsent(string4, string -> new TransformedEvent.NS(namespace, Namespaces.getPreferredPrefix(string, namespace.getPrefix()), (String)string));
            }
            Namespace namespace2 = this.uniqueNamespaces.put(string2, namespace);
            if (namespace2 != null) {
                return namespace2;
            }
        }
        return namespace;
    }

    private List<Namespace> export(Iterator<Namespace> iterator, boolean bl) {
        Namespace[] namespaceArray;
        if (!iterator.hasNext()) {
            return bl ? Collections.emptyList() : null;
        }
        do {
            bl |= (namespaceArray = iterator.next()) != this.exportIfNew((Namespace)namespaceArray);
        } while (iterator.hasNext());
        if (bl) {
            assert (!this.uniqueNamespaces.isEmpty());
            namespaceArray = this.uniqueNamespaces.values().toArray(new Namespace[this.uniqueNamespaces.size()]);
            this.uniqueNamespaces.clear();
            return Arrays.asList(namespaceArray);
        }
        this.uniqueNamespaces.clear();
        return null;
    }

    @Override
    public void add(XMLEvent xMLEvent) throws XMLStreamException {
        switch (xMLEvent.getEventType()) {
            case 10: {
                xMLEvent = this.convert((Attribute)xMLEvent);
                break;
            }
            case 13: {
                int n = this.uniqueNamespaces.size();
                xMLEvent = this.exportIfNew((Namespace)xMLEvent);
                if (this.uniqueNamespaces.size() != n) break;
                return;
            }
            case 2: {
                EndElement endElement = xMLEvent.asEndElement();
                QName qName = endElement.getName();
                QName qName2 = this.convert(qName);
                List<Namespace> list = this.export(endElement.getNamespaces(), qName2 != qName);
                if (list != null) {
                    xMLEvent = new TransformedEvent.End(endElement, qName2, list);
                }
                if (this.toSkip != null) {
                    if (qName.equals(this.subtreeRootName)) {
                        --this.subtreeNesting;
                    } else if (this.subtreeNesting == 0) {
                        this.writeDeferred(null);
                    }
                }
                this.close(qName);
                break;
            }
            case 1: {
                Set<QName> set;
                this.uniqueNamespaces.clear();
                StartElement startElement = xMLEvent.asStartElement();
                QName qName = startElement.getName();
                this.open(qName);
                QName qName3 = this.convert(qName);
                boolean bl = qName3 != qName;
                List<Namespace> list = startElement.getAttributes();
                while (list.hasNext()) {
                    Attribute attribute;
                    set = list.next();
                    bl |= set != (attribute = this.convert((Attribute)((Object)set)));
                    this.renamedAttributes.add(attribute);
                }
                list = this.export(startElement.getNamespaces(), bl);
                if (list != null) {
                    xMLEvent = new Event(startElement, qName3, list, this.attributes(), this.version);
                } else {
                    this.renamedAttributes.clear();
                }
                if (this.toSkip == null) {
                    this.toSkip = ELEMENTS_TO_REORDER.get(qName);
                    if (this.toSkip == null) break;
                    this.subtreeRootName = qName;
                    this.subtreeNesting = 1;
                    this.isDeferring = true;
                    break;
                }
                if (this.subtreeNesting == 0) {
                    if (!this.toSkip.contains(qName) && !this.writeDeferred(qName)) break;
                    this.subtreeRootName = qName;
                    this.subtreeNesting = 1;
                    set = ELEMENTS_TO_REORDER.get(qName);
                    if (set == null) break;
                    this.isDeferring = true;
                    this.deferred.add(new NewDeferred(set));
                    break;
                }
                if (!qName.equals(this.subtreeRootName)) break;
                ++this.subtreeNesting;
                break;
            }
        }
        if (this.isDeferring) {
            this.deferred.add(xMLEvent);
            this.isDeferring = this.subtreeNesting != 0;
        } else {
            this.out.add(xMLEvent);
        }
    }

    private boolean writeDeferred(QName qName) throws XMLStreamException {
        Object object;
        this.subtreeRootName = null;
        this.toSkip = null;
        while ((object = this.deferred.poll()) != null) {
            Set<QName> set;
            if (!(object instanceof NewDeferred)) {
                this.out.add((XMLEvent)object);
                continue;
            }
            if (qName == null || !(set = ((NewDeferred)object).toSkip).contains(qName)) continue;
            this.toSkip = set;
            return true;
        }
        return false;
    }

    @Override
    public void add(XMLEventReader xMLEventReader) throws XMLStreamException {
        while (xMLEventReader.hasNext()) {
            this.add(xMLEventReader.nextEvent());
        }
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        throw new XMLStreamException(Errors.format((short)162, "getPrefix"));
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        this.out.setPrefix(string, this.relocate(string2));
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.out.setDefaultNamespace(this.relocate(string));
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.out.setNamespaceContext(TransformingNamespaces.asXML(namespaceContext, this.version));
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return TransformingNamespaces.asJAXB(this.out.getNamespaceContext(), this.version);
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writeDeferred(null);
        this.out.flush();
    }

    @Override
    public void close() throws XMLStreamException {
        this.uniqueNamespaces.clear();
        super.close();
        this.out.close();
    }

    static {
        HashMap<QName, Set<QName>> hashMap = new HashMap<QName, Set<QName>>(4);
        hashMap.put(new QName("http://standards.iso.org/iso/19115/-3/srv/2.0", "couplingType", "srv"), Collections.singleton(new QName("http://standards.iso.org/iso/19115/-3/srv/2.0", "coupledResource", "srv")));
        hashMap.put(new QName("http://standards.iso.org/iso/19115/-3/srv/2.0", "connectPoint", "srv"), Collections.singleton(new QName("http://standards.iso.org/iso/19115/-3/srv/2.0", "parameter", "srv")));
        QName qName = new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "extent", "mri");
        HashSet<QName> hashSet = new HashSet<QName>(Arrays.asList(qName, new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "additionalDocumentation", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "processingLevel", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "resourceMaintenance", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "graphicOverview", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "resourceFormat", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "descriptiveKeywords", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "resourceSpecificUsage", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "resourceConstraints", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "associatedResource", "mri"), new QName("http://www.isotc211.org/2005/gmd", "aggregationInfo", "gmd"), new QName("http://www.isotc211.org/2005/gmd", "language", "gmd"), new QName("http://www.isotc211.org/2005/gmd", "characterSet", "gmd"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "defaultLocale", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "otherLocale", "mri")));
        hashMap.put(new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "topicCategory", "mri"), CollectionsExt.clone(hashSet));
        hashSet.remove(qName);
        hashSet.add(new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "environmentDescription", "mri"));
        hashMap.put(qName, hashSet);
        ELEMENTS_TO_REORDER = hashMap;
    }

    private static final class Event
    extends TransformedEvent.Start {
        Event(StartElement startElement, QName qName, List<Namespace> list, List<Attribute> list2, TransformVersion transformVersion) {
            super(startElement, qName, list, list2, transformVersion);
        }

        @Override
        public String getNamespaceURI(String string) {
            return this.version.exportNS(((StartElement)this.event).getNamespaceURI(string));
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return TransformingNamespaces.asXML(((StartElement)this.event).getNamespaceContext(), this.version);
        }
    }

    private static final class NewDeferred {
        final Set<QName> toSkip;

        NewDeferred(Set<QName> set) {
            this.toSkip = set;
        }
    }
}

