/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.lan;

import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.util.Bag;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;

public final class LocaleAndCharset
implements TreeTable.Node {
    private final TreeTable.Node node;

    public LocaleAndCharset(TreeTable.Node node) {
        this.node = node;
    }

    @Override
    public TreeTable.Node getParent() {
        return this.node.getParent();
    }

    @Override
    public boolean isEditable(TableColumn<?> tableColumn) {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    private static Object keyOrValue(Object object, boolean bl) {
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            object = bl ? entry.getKey() : entry.getValue();
        }
        return object;
    }

    @Override
    public Object getUserObject() {
        return LocaleAndCharset.keyOrValue(this.node.getUserObject(), true);
    }

    @Override
    public <V> V getValue(TableColumn<V> tableColumn) {
        return this.separateValue(tableColumn, true);
    }

    private <V> V separateValue(TableColumn<V> tableColumn, boolean bl) {
        V v = this.node.getValue(tableColumn);
        if (TableColumn.VALUE.equals(tableColumn)) {
            v = tableColumn.getElementType().cast(LocaleAndCharset.keyOrValue(v, bl));
        }
        return v;
    }

    @Override
    public <V> void setValue(TableColumn<V> tableColumn, V v) {
        if (TableColumn.VALUE.equals(tableColumn)) {
            throw new UnsupportedOperationException();
        }
        this.node.setValue(tableColumn, v);
    }

    @Override
    public Collection<TreeTable.Node> getChildren() {
        return new AbstractList<TreeTable.Node>(){

            @Override
            public int size() {
                return LocaleAndCharset.keyOrValue(LocaleAndCharset.this.node.getUserObject(), false) != null ? 1 : 0;
            }

            @Override
            public TreeTable.Node get(int n) {
                ArgumentChecks.ensureValidIndex(1, n);
                return new Child();
            }
        };
    }

    @Override
    public TreeTable.Node newChild() {
        if (LocaleAndCharset.keyOrValue(this.node.getUserObject(), false) != null) {
            throw new UnsupportedOperationException();
        }
        return new Child();
    }

    @Override
    public int hashCode() {
        return this.node.hashCode() ^ 0x25;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof LocaleAndCharset && this.node.equals(((LocaleAndCharset)object).node);
    }

    public static Collection<Locale> getLanguages(final Map<Locale, Charset> map) {
        if (map == null) {
            return null;
        }
        return new AbstractSet<Locale>(){

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public void clear() {
                map.clear();
            }

            @Override
            public boolean contains(Object object) {
                return map.containsKey(object);
            }

            @Override
            public Iterator<Locale> iterator() {
                return map.keySet().iterator();
            }

            @Override
            public boolean add(Locale locale) {
                if (locale == null || map.containsKey(locale)) {
                    return false;
                }
                Charset charset = (Charset)map.remove(null);
                map.put(locale, charset);
                return true;
            }
        };
    }

    public static Collection<Charset> getCharacterSets(final Map<Locale, Charset> map) {
        if (map == null) {
            return null;
        }
        return new Bag<Charset>(){

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public void clear() {
                map.clear();
            }

            @Override
            public boolean contains(Object object) {
                return map.containsValue(object);
            }

            @Override
            public Iterator<Charset> iterator() {
                return map.values().iterator();
            }

            @Override
            public boolean add(Charset charset) {
                if (charset == null) {
                    return false;
                }
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() != null) continue;
                    entry.setValue(charset);
                    return true;
                }
                return map.putIfAbsent(null, charset) != charset;
            }
        };
    }

    public static Map<Locale, Charset> setLanguages(Map<Locale, Charset> map, Collection<? extends Locale> collection) {
        Charset charset;
        Charset charset2 = charset = map != null ? CollectionsExt.first(map.values()) : null;
        if (collection == null || collection.isEmpty()) {
            if (map != null) {
                map.clear();
            }
        } else {
            if (map == null) {
                map = new LinkedHashMap<Locale, Charset>();
            }
            map.keySet().retainAll(collection);
            for (Locale locale : collection) {
                map.putIfAbsent(locale, null);
            }
        }
        if (charset != null && !map.values().contains(charset)) {
            map.put(null, charset);
        }
        return map;
    }

    public static Map<Locale, Charset> setCharacterSets(Map<Locale, Charset> map, Collection<? extends Charset> collection) {
        Charset charset = CollectionsExt.first(collection);
        if (map != null || charset != null) {
            if (map == null) {
                map = new LinkedHashMap<Locale, Charset>();
            }
            if (map.isEmpty()) {
                map.put(null, charset);
            } else {
                for (Map.Entry<Locale, Charset> entry : map.entrySet()) {
                    entry.setValue(charset);
                }
            }
        }
        return map;
    }

    private final class Child
    implements TreeTable.Node {
        private Child() {
        }

        @Override
        public TreeTable.Node getParent() {
            return LocaleAndCharset.this;
        }

        @Override
        public Object getUserObject() {
            return LocaleAndCharset.keyOrValue(LocaleAndCharset.this.node.getUserObject(), false);
        }

        @Override
        public boolean isEditable(TableColumn<?> tableColumn) {
            return LocaleAndCharset.this.node.isEditable(tableColumn);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Collection<TreeTable.Node> getChildren() {
            return Collections.emptySet();
        }

        @Override
        public TreeTable.Node newChild() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> V getValue(TableColumn<V> tableColumn) {
            String string;
            if (TableColumn.IDENTIFIER.equals(tableColumn)) {
                string = "characterSet";
            } else if (TableColumn.NAME.equals(tableColumn)) {
                string = "Character set";
            } else {
                return (V)LocaleAndCharset.this.separateValue(tableColumn, false);
            }
            return tableColumn.getElementType().cast(string);
        }

        @Override
        public <V> void setValue(TableColumn<V> tableColumn, V v) {
            if (TableColumn.VALUE.equals(tableColumn)) {
                ((Map.Entry)LocaleAndCharset.this.node.getUserObject()).setValue(v);
            } else {
                LocaleAndCharset.this.node.setValue(tableColumn, v);
            }
        }

        @Override
        public int hashCode() {
            return ~this.getParent().hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Child && this.getParent().equals(((Child)object).getParent());
        }
    }
}

