/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part1.objectdescriptors;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.Descriptor;
import org.mp4parser.tools.IsoTypeReader;

@Descriptor(tags={0})
public abstract class BaseDescriptor {
    int tag;
    int sizeOfInstance;
    int sizeBytes;

    public int getTag() {
        return this.tag;
    }

    public void writeSize(ByteBuffer bb, int size) {
        int pos = bb.position();
        int i = 0;
        while (size > 0 || i < this.sizeBytes) {
            ++i;
            if (size > 0) {
                bb.put(pos + this.getSizeSize() - i, (byte)(size & 0x7F));
            } else {
                bb.put(pos + this.getSizeSize() - i, (byte)-128);
            }
            size >>>= 7;
        }
        ((Buffer)bb).position(pos + this.getSizeSize());
    }

    public int getSizeSize() {
        int size = this.getContentSize();
        int i = 0;
        while (size > 0 || i < this.sizeBytes) {
            size >>>= 7;
            ++i;
        }
        return i;
    }

    public int getSize() {
        return this.getContentSize() + this.getSizeSize() + 1;
    }

    public final void parse(int tag, ByteBuffer bb) throws IOException {
        this.tag = tag;
        int i = 0;
        int tmp = IsoTypeReader.readUInt8(bb);
        ++i;
        this.sizeOfInstance = tmp & 0x7F;
        while (tmp >>> 7 == 1) {
            tmp = IsoTypeReader.readUInt8(bb);
            ++i;
            this.sizeOfInstance = this.sizeOfInstance << 7 | tmp & 0x7F;
        }
        this.sizeBytes = i;
        ByteBuffer detailSource = bb.slice();
        ((Buffer)detailSource).limit(this.sizeOfInstance);
        this.parseDetail(detailSource);
        assert (detailSource.remaining() == 0) : String.valueOf(this.getClass().getSimpleName()) + " has not been fully parsed";
        ((Buffer)bb).position(bb.position() + this.sizeOfInstance);
    }

    public abstract void parseDetail(ByteBuffer var1) throws IOException;

    public abstract ByteBuffer serialize();

    abstract int getContentSize();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BaseDescriptor");
        sb.append("{tag=").append(this.tag);
        sb.append(", sizeOfInstance=").append(this.sizeOfInstance);
        sb.append('}');
        return sb.toString();
    }
}

