/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.async.logger.AsyncLoggerConfigDisruptor;
import org.apache.logging.log4j.async.logger.DisruptorConfiguration;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.AsyncQueueFullMessageUtil;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.kit.logger.AbstractLogger;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginFactory;

@Configurable(printObject=true)
@Plugin(value="AsyncLogger")
public final class AsyncLoggerConfig
extends LoggerConfig {
    private static final ThreadLocal<Boolean> ASYNC_LOGGER_ENTERED = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private AsyncLoggerConfigDisruptor disruptor;

    @PluginFactory
    public static <B extends Builder<B>> B newAsyncBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private AsyncLoggerConfig(String name, List<AppenderRef> appenders, Filter filter, Level level, boolean additive, Property[] properties, Configuration config, boolean includeLocation) {
        super(name, appenders, filter, level, additive, properties, config, includeLocation);
    }

    public void initialize() {
        Configuration configuration = this.getConfiguration();
        DisruptorConfiguration disruptorConfiguration = (DisruptorConfiguration)configuration.addExtensionIfAbsent(DisruptorConfiguration.class, () -> DisruptorConfiguration.newBuilder().setConfiguration(configuration).build());
        this.disruptor = disruptorConfiguration.getLoggerConfigDisruptor();
        super.initialize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void log(LogEvent event, Predicate<LoggerConfig> predicate) {
        if (predicate == null && ASYNC_LOGGER_ENTERED.get() == Boolean.FALSE && this.hasAppenders()) {
            ASYNC_LOGGER_ENTERED.set(Boolean.TRUE);
            try {
                if (this.isFiltered(event)) return;
                this.processLogEvent(event, lc -> !(lc instanceof AsyncLoggerConfig));
                this.logToAsyncDelegate(event);
                return;
            }
            finally {
                ASYNC_LOGGER_ENTERED.set(Boolean.FALSE);
            }
        } else {
            super.log(event, predicate);
        }
    }

    AsyncLoggerConfigDisruptor getAsyncLoggerConfigDisruptor() {
        return this.disruptor;
    }

    protected void callAppenders(LogEvent event) {
        super.callAppenders(event);
    }

    private void logToAsyncDelegate(LogEvent event) {
        if (!this.disruptor.tryEnqueue(event, this)) {
            this.handleQueueFull(event);
        }
    }

    private void handleQueueFull(LogEvent event) {
        if (AbstractLogger.getRecursionDepth() > 1) {
            AsyncQueueFullMessageUtil.logWarningToStatusLogger();
            this.logToAsyncLoggerConfigsOnCurrentThread(event);
        } else {
            EventRoute eventRoute = this.disruptor.getEventRoute(event.getLevel());
            switch (eventRoute) {
                case DISCARD: {
                    break;
                }
                case ENQUEUE: {
                    this.logInBackgroundThread(event);
                    break;
                }
                case SYNCHRONOUS: {
                    this.logToAsyncLoggerConfigsOnCurrentThread(event);
                    break;
                }
            }
        }
    }

    void logInBackgroundThread(LogEvent event) {
        this.disruptor.enqueueEvent(event, this);
    }

    void logToAsyncLoggerConfigsOnCurrentThread(LogEvent event) {
        this.processLogEvent(event, lc -> lc instanceof AsyncLoggerConfig);
    }

    private String displayName() {
        return "".equals(this.getName()) ? "root" : this.getName();
    }

    public void start() {
        LOGGER.trace("AsyncLoggerConfig[{}] starting...", (Object)this.displayName());
        super.start();
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        LOGGER.trace("AsyncLoggerConfig[{}] stopping...", (Object)this.displayName());
        this.setStopped();
        return true;
    }

    public static class Builder<B extends Builder<B>>
    extends LoggerConfig.Builder<B> {
        public LoggerConfig build() {
            String name = this.getLoggerName().equals("root") ? "" : this.getLoggerName();
            Configuration config = this.getConfig();
            LoggerConfig.LevelAndRefs container = AsyncLoggerConfig.getLevelAndRefs((Level)this.getLevel(), (AppenderRef[])this.getRefs(), (String)this.getLevelAndRefs(), (Configuration)config);
            boolean includeLocation = Boolean.TRUE.equals(this.getIncludeLocation());
            return new AsyncLoggerConfig(name, container.refs, this.getFilter(), container.level, this.isAdditivity(), this.getProperties(), config, includeLocation);
        }
    }

    @Configurable(printObject=true)
    @Plugin(value="AsyncRoot")
    public static final class RootLogger
    extends LoggerConfig {
        @PluginFactory
        public static Builder newAsyncRootBuilder() {
            return new Builder();
        }

        private RootLogger() {
            super("", Level.ERROR, false, null);
        }

        public static class Builder
        extends LoggerConfig.RootLogger.Builder {
            public LoggerConfig build() {
                LoggerConfig.LevelAndRefs container = RootLogger.getLevelAndRefs((Level)this.getLevel(), (AppenderRef[])this.getRefs(), (String)this.getLevelAndRefs(), (Configuration)this.getConfig());
                boolean includeLocation = Boolean.TRUE.equals(this.getIncludeLocation());
                return new AsyncLoggerConfig("", container.refs, this.getFilter(), container.level, true, this.getProperties(), this.getConfig(), includeLocation);
            }
        }
    }
}

