/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.filter.MapFilter;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.kit.recycler.Recycler;
import org.apache.logging.log4j.kit.recycler.RecyclerFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StringBuilders;

@Configurable(elementType="filter", printObject=true)
@Plugin
@PerformanceSensitive(value={"allocation"})
public final class StructuredDataFilter
extends MapFilter {
    private static final int MAX_BUFFER_SIZE = 2048;
    private final Recycler<StringBuilder> stringBuilderRecycler;

    private StructuredDataFilter(RecyclerFactory recyclerFactory, Map<String, List<String>> map, boolean oper, Filter.Result onMatch, Filter.Result onMismatch) {
        super(map, oper, onMatch, onMismatch);
        this.stringBuilderRecycler = recyclerFactory.create(StringBuilder::new);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        if (msg instanceof StructuredDataMessage) {
            return this.filter((StructuredDataMessage)msg);
        }
        return Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(LogEvent event) {
        Message msg = event.getMessage();
        if (msg instanceof StructuredDataMessage) {
            return this.filter((StructuredDataMessage)msg);
        }
        return super.filter(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Filter.Result filter(StructuredDataMessage message) {
        boolean match = false;
        IndexedReadOnlyStringMap map = this.getStringMap();
        StringBuilder sb = (StringBuilder)this.stringBuilderRecycler.acquire();
        try {
            for (int i = 0; i < map.size(); ++i) {
                StringBuilder toMatch = this.getValue(sb, message, map.getKeyAt(i));
                if (toMatch != null) {
                    List candidates = (List)map.getValueAt(i);
                    match = this.listContainsValue(candidates, toMatch);
                } else {
                    match = false;
                }
                if (!this.isAnd() && match) break;
                if (this.isAnd() && !match) {
                    break;
                }
                StringBuilders.trimToMaxSize((StringBuilder)sb, (int)2048);
                sb.setLength(0);
            }
        }
        finally {
            this.stringBuilderRecycler.release((Object)sb);
        }
        return match ? this.onMatch : this.onMismatch;
    }

    private StringBuilder getValue(StringBuilder sb, StructuredDataMessage data, String key) {
        if (key.equalsIgnoreCase("id")) {
            data.getId().formatTo(sb);
            return sb;
        }
        if (key.equalsIgnoreCase("id.name")) {
            return this.appendOrNull(data.getId().getName(), sb);
        }
        if (key.equalsIgnoreCase("type")) {
            return this.appendOrNull(data.getType(), sb);
        }
        if (key.equalsIgnoreCase("message")) {
            data.formatTo(sb);
            return sb;
        }
        return this.appendOrNull(data.get(key), sb);
    }

    private StringBuilder appendOrNull(String value, StringBuilder sb) {
        if (value == null) {
            return null;
        }
        sb.append(value);
        return sb;
    }

    private boolean listContainsValue(List<String> candidates, StringBuilder toMatch) {
        if (toMatch == null) {
            for (int i = 0; i < candidates.size(); ++i) {
                String candidate = candidates.get(i);
                if (candidate != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < candidates.size(); ++i) {
                String candidate = candidates.get(i);
                if (candidate == null) {
                    return false;
                }
                if (!StringBuilders.equals((CharSequence)candidate, (int)0, (int)candidate.length(), (CharSequence)toMatch, (int)0, (int)toMatch.length())) continue;
                return true;
            }
        }
        return false;
    }

    @PluginFactory
    public static StructuredDataFilter createFilter(@PluginConfiguration Configuration configuration, @PluginElement KeyValuePair[] pairs, @PluginAttribute String operator, @PluginAttribute Filter.Result onMatch, @PluginAttribute Filter.Result onMismatch) {
        if (pairs == null || pairs.length == 0) {
            LOGGER.error("keys and values must be specified for the StructuredDataFilter");
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (KeyValuePair pair : pairs) {
            String key = pair.getKey();
            if (key == null) {
                LOGGER.error("A null key is not valid in MapFilter");
                continue;
            }
            String value = pair.getValue();
            if (value == null) {
                LOGGER.error("A null value for key " + key + " is not allowed in MapFilter");
                continue;
            }
            ArrayList<String> list = (ArrayList<String>)map.get(pair.getKey());
            if (list != null) {
                list.add(value);
                continue;
            }
            list = new ArrayList<String>();
            list.add(value);
            map.put(pair.getKey(), list);
        }
        if (map.isEmpty()) {
            LOGGER.error("StructuredDataFilter is not configured with any valid key value pairs");
            return null;
        }
        boolean isAnd = operator == null || !operator.equalsIgnoreCase("or");
        RecyclerFactory recyclerFactory = configuration.getRecyclerFactory();
        return new StructuredDataFilter(recyclerFactory, map, isAnd, onMatch, onMismatch);
    }
}

