/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jndi.selector;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.selector.AbstractContextSelector;
import org.apache.logging.log4j.core.selector.NamedContextSelector;
import org.apache.logging.log4j.jndi.JndiManager;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Singleton;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Lazy;

@Singleton
public class JndiContextSelector
extends AbstractContextSelector
implements NamedContextSelector {
    private final Lazy<LoggerContext> defaultContextLazy = Lazy.lazy(() -> this.createContext("Default", null, JndiContextSelector.class.getClassLoader()));
    private final ConcurrentMap<String, LoggerContext> CONTEXT_MAP = new ConcurrentHashMap<String, LoggerContext>();
    private static final StatusLogger LOGGER = StatusLogger.getLogger();

    @Inject
    public JndiContextSelector(ConfigurableInstanceFactory instanceFactory) {
        super(instanceFactory);
        if (!JndiManager.isJndiContextSelectorEnabled()) {
            throw new IllegalStateException("JNDI must be enabled by setting log4j.jndi.enableContextSelector=true");
        }
    }

    public void shutdown(String fqcn, ClassLoader loader, boolean currentContext, boolean allContexts) {
        String loggingContextName;
        LoggerContext ctx = (LoggerContext)ContextAnchor.THREAD_CONTEXT.get();
        if (ctx == null && (loggingContextName = JndiContextSelector.getContextName()) != null) {
            ctx = (LoggerContext)this.CONTEXT_MAP.get(loggingContextName);
        }
        if (ctx != null) {
            ctx.stop(50L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean hasContext(String fqcn, ClassLoader loader, boolean currentContext) {
        LoggerContext ctx = (LoggerContext)ContextAnchor.THREAD_CONTEXT.get();
        if (ctx == null) {
            String loggingContextName = JndiContextSelector.getContextName();
            if (loggingContextName == null) {
                return false;
            }
            ctx = (LoggerContext)this.CONTEXT_MAP.get(loggingContextName);
        }
        return ctx != null && ctx.isStarted();
    }

    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        return this.getContext(fqcn, loader, currentContext, null);
    }

    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation) {
        LoggerContext lc = (LoggerContext)ContextAnchor.THREAD_CONTEXT.get();
        if (lc != null) {
            return lc;
        }
        String loggingContextName = JndiContextSelector.getContextName();
        return loggingContextName == null ? (LoggerContext)this.defaultContextLazy.get() : this.locateContext(loggingContextName, null, configLocation);
    }

    private static String getContextName() {
        String loggingContextName = null;
        try (JndiManager jndiManager = JndiManager.getDefaultManager();){
            loggingContextName = (String)jndiManager.lookup("java:comp/env/log4j/context-name");
        }
        catch (NamingException ne) {
            LOGGER.error("Unable to lookup {}", (Object)"java:comp/env/log4j/context-name", (Object)ne);
        }
        return loggingContextName;
    }

    public LoggerContext locateContext(String name, Object externalContext, URI configLocation) {
        if (name == null) {
            LOGGER.error("A context name is required to locate a LoggerContext");
            return null;
        }
        if (!this.CONTEXT_MAP.containsKey(name)) {
            LoggerContext ctx = this.createContext(name, configLocation, JndiContextSelector.class.getClassLoader());
            this.CONTEXT_MAP.putIfAbsent(name, ctx);
        }
        return (LoggerContext)this.CONTEXT_MAP.get(name);
    }

    public void removeContext(LoggerContext context) {
        for (Map.Entry entry : this.CONTEXT_MAP.entrySet()) {
            if (!((LoggerContext)entry.getValue()).equals(context)) continue;
            this.CONTEXT_MAP.remove(entry.getKey());
        }
    }

    public boolean isClassLoaderDependent() {
        return false;
    }

    public LoggerContext removeContext(String name) {
        return (LoggerContext)this.CONTEXT_MAP.remove(name);
    }

    public List<LoggerContext> getLoggerContexts() {
        return Collections.unmodifiableList(new ArrayList(this.CONTEXT_MAP.values()));
    }
}

