/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.metadata;

import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.knox.gateway.service.metadata.ServiceModel;

@XmlRootElement(name="topology")
public class TopologyInformation
implements Comparable<TopologyInformation> {
    @XmlElement(name="topology")
    private String topologyName;
    @XmlElement(name="pinned")
    private boolean pinned;
    @XmlElement(name="apiServicesViewVersion")
    private String apiServicesViewVersion;
    @XmlElement(name="service")
    @XmlElementWrapper(name="apiServices")
    private Set<ServiceModel> apiServices;
    @XmlElement(name="service")
    @XmlElementWrapper(name="uiServices")
    private Set<ServiceModel> uiServices;

    public String getTopologyName() {
        return this.topologyName;
    }

    public void setTopologyName(String topologyName) {
        this.topologyName = topologyName;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public void setApiServicesViewVersion(String apiServicesViewVersion) {
        this.apiServicesViewVersion = apiServicesViewVersion;
    }

    public String getApiServicesViewVersion() {
        return this.apiServicesViewVersion;
    }

    public Set<ServiceModel> getApiServices() {
        return this.apiServices;
    }

    public void setApiServices(Set<ServiceModel> apiServices) {
        this.apiServices = apiServices;
    }

    public Set<ServiceModel> getUiServices() {
        return this.uiServices;
    }

    public void setUiServices(Set<ServiceModel> uiServices) {
        this.uiServices = uiServices;
    }

    @Override
    public int compareTo(TopologyInformation other) {
        int byPinned = Boolean.compare(other.pinned, this.pinned);
        return byPinned == 0 ? this.topologyName.compareTo(other.topologyName) : byPinned;
    }
}

