/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.global;

import java.security.PublicKey;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.helpers.AbstractConnectionServiceRequestHandler;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;

public abstract class AbstractOpenSshHostKeysHandler
extends AbstractConnectionServiceRequestHandler {
    private final String request;
    private final BufferPublicKeyParser<? extends PublicKey> parser;

    protected AbstractOpenSshHostKeysHandler(String request) {
        this(request, BufferPublicKeyParser.DEFAULT);
    }

    protected AbstractOpenSshHostKeysHandler(String request, BufferPublicKeyParser<? extends PublicKey> parser) {
        this.request = ValidateUtils.checkNotNullAndNotEmpty(request, "No request identifier");
        this.parser = Objects.requireNonNull(parser, "No public keys extractor");
    }

    public final String getRequestName() {
        return this.request;
    }

    public BufferPublicKeyParser<? extends PublicKey> getPublicKeysParser() {
        return this.parser;
    }

    @Override
    public RequestHandler.Result process(ConnectionService connectionService, String request, boolean wantReply, Buffer buffer) throws Exception {
        String expected = this.getRequestName();
        if (!expected.equals(request)) {
            return super.process(connectionService, request, wantReply, buffer);
        }
        LinkedList<PublicKey> keys = new LinkedList<PublicKey>();
        BufferPublicKeyParser<? extends PublicKey> p = this.getPublicKeysParser();
        if (p != null) {
            while (buffer.available() > 0) {
                PublicKey key = buffer.getPublicKey(p);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({})[{}] key type={}, fingerprint={}", new Object[]{connectionService, request, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key)});
                }
                if (key == null) continue;
                keys.add(key);
            }
        }
        return this.handleHostKeys(connectionService.getSession(), keys, wantReply, buffer);
    }

    protected abstract RequestHandler.Result handleHostKeys(Session var1, Collection<? extends PublicKey> var2, boolean var3, Buffer var4) throws Exception;

    public String toString() {
        return this.getRequestName();
    }
}

