/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jms.impl;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSConsumer;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.ops4j.pax.transx.jms.impl.JMSContextImpl;
import org.ops4j.pax.transx.jms.impl.Utils;

public class JMSConsumerImpl
implements JMSConsumer {
    private final JMSContextImpl context;
    private final MessageConsumer consumer;

    JMSConsumerImpl(JMSContextImpl context, MessageConsumer consumer) {
        this.context = context;
        this.consumer = consumer;
    }

    public String getMessageSelector() {
        try {
            return this.consumer.getMessageSelector();
        }
        catch (JMSException e) {
            throw Utils.convertToRuntimeException(e);
        }
    }

    public MessageListener getMessageListener() throws JMSRuntimeException {
        try {
            return this.consumer.getMessageListener();
        }
        catch (JMSException e) {
            throw Utils.convertToRuntimeException(e);
        }
    }

    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        try {
            this.consumer.setMessageListener((MessageListener)new MessageListenerWrapper(listener));
        }
        catch (JMSException e) {
            throw Utils.convertToRuntimeException(e);
        }
    }

    public Message receive() {
        try {
            return this.context.setLastMessage(this.consumer.receive());
        }
        catch (JMSException e) {
            throw Utils.convertToRuntimeException(e);
        }
    }

    public Message receive(long timeout) {
        try {
            return this.context.setLastMessage(this.consumer.receive(timeout));
        }
        catch (JMSException e) {
            throw Utils.convertToRuntimeException(e);
        }
    }

    public Message receiveNoWait() {
        try {
            return this.context.setLastMessage(this.consumer.receiveNoWait());
        }
        catch (JMSException e) {
            throw Utils.convertToRuntimeException(e);
        }
    }

    public void close() {
        try {
            this.consumer.close();
        }
        catch (JMSException e) {
            throw Utils.convertToRuntimeException(e);
        }
    }

    public <T> T receiveBody(Class<T> c) {
        try {
            Message message = this.context.setLastMessage(this.consumer.receive());
            return this.getBody(c, message);
        }
        catch (JMSException e) {
            throw Utils.convertToRuntimeException(e);
        }
    }

    public <T> T receiveBody(Class<T> c, long timeout) {
        try {
            Message message = this.context.setLastMessage(this.consumer.receive(timeout));
            return this.getBody(c, message);
        }
        catch (JMSException e) {
            throw Utils.convertToRuntimeException(e);
        }
    }

    public <T> T receiveBodyNoWait(Class<T> c) {
        try {
            Message message = this.context.setLastMessage(this.consumer.receiveNoWait());
            return this.getBody(c, message);
        }
        catch (JMSException e) {
            throw Utils.convertToRuntimeException(e);
        }
    }

    private <T> T getBody(Class<T> c, Message msg) throws JMSException {
        if (msg == null) {
            return null;
        }
        if (c == String.class && msg instanceof TextMessage) {
            return (T)((TextMessage)msg).getText();
        }
        if (c == byte[].class && msg instanceof BytesMessage) {
            long l = ((BytesMessage)msg).getBodyLength();
            if (l > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException();
            }
            byte[] data = new byte[(int)l];
            ((BytesMessage)msg).readBytes(data);
            return (T)data;
        }
        if (c == Map.class && msg instanceof MapMessage) {
            HashMap<String, String> map = new HashMap<String, String>();
            Enumeration e = ((MapMessage)msg).getMapNames();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                map.put(k, ((MapMessage)msg).getString(k));
            }
            return (T)map;
        }
        throw new UnsupportedOperationException();
    }

    final class MessageListenerWrapper
    implements MessageListener {
        final MessageListener wrapped;

        MessageListenerWrapper(MessageListener wrapped) {
            this.wrapped = wrapped;
        }

        public void onMessage(Message message) {
            JMSConsumerImpl.this.context.setLastMessage(message);
            this.wrapped.onMessage(message);
        }
    }
}

