/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.RequestHeader;
import org.apache.juneau.rest.httppart.RequestHttpPart;
import org.apache.juneau.rest.httppart.RequestQueryParams;
import org.apache.juneau.svl.VarResolverSession;

public class RequestHeaders
extends ArrayList<RequestHeader> {
    private static final long serialVersionUID = 1L;
    private final RestRequest req;
    private boolean caseSensitive;
    private final VarResolverSession vs;
    private HttpPartParserSession parser;

    public RequestHeaders(RestRequest req, RequestQueryParams query, boolean caseSensitive) {
        this.req = req;
        this.caseSensitive = caseSensitive;
        this.vs = req.getVarResolverSession();
        Enumeration e = req.getHttpServletRequest().getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Enumeration ve = req.getHttpServletRequest().getHeaders(name);
            while (ve.hasMoreElements()) {
                this.add(new RequestHeader(req, name, (String)ve.nextElement()));
            }
        }
        Set<String> allowedHeaderParams = req.getContext().getAllowedHeaderParams();
        query.forEach((? super E p) -> {
            String name = p.getName();
            String key = this.key(name);
            if (allowedHeaderParams.contains(key) || allowedHeaderParams.contains("*")) {
                this.set(name, p.getValue());
            }
        });
    }

    private RequestHeaders(RequestHeaders copyFrom) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.addAll(copyFrom);
        this.vs = copyFrom.vs;
    }

    private RequestHeaders(RequestHeaders copyFrom, String ... names) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.vs = copyFrom.vs;
        for (String n : names) {
            copyFrom.stream().filter(x -> this.eq(x.getName(), n)).forEach(this::add);
        }
    }

    public RequestHeaders add(Header ... headers) {
        AssertionUtils.assertArgNotNull("headers", headers);
        for (Header h : headers) {
            if (!Utils.nn(h)) continue;
            this.add(h.getName(), h.getValue());
        }
        return this;
    }

    public RequestHeaders add(String name, Object value) {
        AssertionUtils.assertArgNotNull("name", name);
        this.add(new RequestHeader(this.req, name, Utils.s(value)).parser(this.parser));
        return this;
    }

    public RequestHeaders addDefault(Header ... pairs) {
        return this.addDefault(CollectionUtils.l(pairs));
    }

    public RequestHeaders addDefault(List<Header> pairs) {
        AssertionUtils.assertArgNotNull("pairs", pairs);
        for (Header p : pairs) {
            String name = p.getName();
            Stream<RequestHeader> l = this.stream(name);
            boolean hasAllBlanks = l.allMatch(x -> Utils.e(x.getValue()));
            if (!hasAllBlanks) continue;
            this.removeAll(this.getAll(name));
            this.add(new RequestHeader(this.req, name, this.vs.resolve(p.getValue())));
        }
        return this;
    }

    public RequestHeaders addDefault(String name, String value) {
        return this.addDefault(BasicStringHeader.of(name, value));
    }

    public RequestHeaders caseSensitive(boolean value) {
        this.caseSensitive = value;
        return this;
    }

    public boolean contains(String name) {
        return this.stream(name).findAny().isPresent();
    }

    public boolean containsAny(String ... names) {
        AssertionUtils.assertArgNotNull("names", names);
        for (String n : names) {
            if (!this.stream(n).findAny().isPresent()) continue;
            return true;
        }
        return false;
    }

    public RequestHeaders copy() {
        return new RequestHeaders(this);
    }

    public <T> Optional<T> get(Class<T> type) {
        ClassMeta<T> cm = this.req.getBeanSession().getClassMeta(type);
        String name = HttpParts.getName(HttpPartType.HEADER, cm).orElseThrow(() -> ThrowableUtils.rex("@Header(name) not found on class {0}", Utils.cn(type)));
        return this.get(name).as(type);
    }

    public RequestHeader get(String name) {
        List<RequestHeader> l = this.getAll(name);
        if (l.isEmpty()) {
            return new RequestHeader(this.req, name, null).parser(this.parser);
        }
        if (l.size() == 1) {
            return l.get(0);
        }
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < l.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(l.get(i).getValue());
        }
        return new RequestHeader(this.req, name, sb.toString()).parser(this.parser);
    }

    public List<RequestHeader> getAll(String name) {
        return this.stream(name).collect(Collectors.toList());
    }

    public RequestHeader getFirst(String name) {
        AssertionUtils.assertArgNotNull("name", name);
        return this.stream(name).findFirst().orElseGet(() -> new RequestHeader(this.req, name, null).parser(this.parser));
    }

    public RequestHeader getLast(String name) {
        AssertionUtils.assertArgNotNull("name", name);
        Value<RequestHeader> v = Value.empty();
        this.stream(name).forEach((? super T x) -> v.set((RequestHeader)x));
        return v.orElseGet(() -> new RequestHeader(this.req, name, null).parser(this.parser));
    }

    public List<String> getNames() {
        return this.stream().map(RequestHttpPart::getName).map(x -> this.caseSensitive ? x : x.toLowerCase()).distinct().collect(Collectors.toList());
    }

    public Stream<RequestHeader> getSorted() {
        Comparator<RequestHeader> x = this.caseSensitive ? Comparator.comparing(RequestHttpPart::getName) : (x1, x2) -> String.CASE_INSENSITIVE_ORDER.compare(x1.getName(), x2.getName());
        return this.stream().sorted(x);
    }

    public RequestHeaders parser(HttpPartParserSession value) {
        this.parser = value;
        this.forEach((? super E x) -> x.parser(this.parser));
        return this;
    }

    public RequestHeaders remove(String name) {
        AssertionUtils.assertArgNotNull("name", name);
        this.removeIf(x -> this.eq(x.getName(), name));
        return this;
    }

    public RequestHeaders set(Header ... headers) {
        AssertionUtils.assertArgNotNull("headers", headers);
        for (Header h : headers) {
            this.remove(h);
        }
        for (Header h : headers) {
            this.add(h);
        }
        return this;
    }

    public RequestHeaders set(String name, Object value) {
        AssertionUtils.assertArgNotNull("name", name);
        this.set(new RequestHeader(this.req, name, Utils.s(value)).parser(this.parser));
        return this;
    }

    public Stream<RequestHeader> stream(String name) {
        return this.stream().filter(x -> this.eq(x.getName(), name));
    }

    public RequestHeaders subset(String ... names) {
        return new RequestHeaders(this, names);
    }

    protected FluentMap<String, Object> properties() {
        FluentMap<String, Object> m = CollectionUtils.filteredBeanPropertyMap();
        for (String n : this.getNames()) {
            m.a(n, this.get(n).asString().orElse(null));
        }
        return m;
    }

    @Override
    public String toString() {
        return Utils.r(this.properties());
    }

    private boolean eq(String s1, String s2) {
        return Utils.eq(!this.caseSensitive, s1, s2);
    }

    private String key(String name) {
        return this.caseSensitive ? name : name.toLowerCase();
    }
}

