/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.matcher;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.matcher.RestMatcher;

public class RestMatcherList {
    private final RestMatcher[] optionalEntries;
    private final RestMatcher[] requiredEntries;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    protected RestMatcherList(Builder builder) {
        List l = builder.entries.stream().map(BeanCreator::run).collect(Collectors.toList());
        this.optionalEntries = (RestMatcher[])l.stream().filter(x -> !x.required()).toArray(RestMatcher[]::new);
        this.requiredEntries = (RestMatcher[])l.stream().filter(RestMatcher::required).toArray(RestMatcher[]::new);
    }

    public RestMatcher[] getOptionalEntries() {
        return this.optionalEntries;
    }

    public RestMatcher[] getRequiredEntries() {
        return this.requiredEntries;
    }

    public static class Builder
    extends BeanBuilder<RestMatcherList> {
        List<BeanCreator<RestMatcher>> entries = CollectionUtils.list((Object[])new BeanCreator[0]);

        protected Builder(BeanStore beanStore) {
            super(RestMatcherList.class, beanStore);
        }

        public Builder append(Class<? extends RestMatcher> ... values) {
            for (Class<? extends RestMatcher> v : values) {
                this.entries.add((BeanCreator<RestMatcher>)this.beanStore().createBean(RestMatcher.class).type(v));
            }
            return this;
        }

        public Builder append(RestMatcher ... values) {
            for (RestMatcher v : values) {
                this.entries.add((BeanCreator<RestMatcher>)this.beanStore().createBean(RestMatcher.class).impl((Object)v));
            }
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        protected RestMatcherList buildDefault() {
            return new RestMatcherList(this);
        }
    }
}

