/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.function;

import org.apache.juneau.commons.function.Consumer3;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;

@FunctionalInterface
public interface ThrowingConsumer3<A, B, C>
extends Consumer3<A, B, C> {
    @Override
    default public void apply(A a, B b, C c) {
        try {
            this.acceptThrows(a, b, c);
        }
        catch (Exception e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    @Override
    default public ThrowingConsumer3<A, B, C> andThen(ThrowingConsumer3<? super A, ? super B, ? super C> after) {
        AssertionUtils.assertArgNotNull("after", after);
        return (a, b, c) -> {
            this.acceptThrows(a, b, c);
            after.acceptThrows(a, b, c);
        };
    }

    public void acceptThrows(A var1, B var2, C var3) throws Exception;
}

