/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import com.google.inject.Module;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.backends.rabbitmq.DockerRabbitMQ;
import org.apache.james.modules.DockerRabbitMQRule;
import org.apache.james.modules.TestRabbitMQModule;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class RabbitMQExtension
implements GuiceModuleTestExtension {
    private final DockerRabbitMQRule rabbitMQRule = new DockerRabbitMQRule();

    public void beforeAll(ExtensionContext extensionContext) {
        this.rabbitMQRule.start();
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.rabbitMQRule.stop();
    }

    public Module getModule() {
        return new TestRabbitMQModule(this.rabbitMQRule.dockerRabbitMQ());
    }

    public DockerRabbitMQ dockerRabbitMQ() {
        return this.rabbitMQRule.dockerRabbitMQ();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == DockerRabbitMQ.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.dockerRabbitMQ();
    }
}

