/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationLocalLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRemoteLevel;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class TextFormattedResultAccessLogMessageHelper
implements Serializable {
    private static final long serialVersionUID = 8094885577945684606L;
    @Nullable
    private final AssuredReplicationLocalLevel assuredReplicationLocalLevel;
    @Nullable
    private final AssuredReplicationRemoteLevel assuredReplicationRemoteLevel;
    @Nullable
    private final Boolean responseDelayedByAssurance;
    @Nullable
    private final Boolean uncachedDataAccessed;
    @Nullable
    private final Double processingTimeMillis;
    @Nullable
    private final Double workQueueWaitTimeMillis;
    @NotNull
    private final List<String> referralURLs;
    @NotNull
    private final List<String> serversAccessed;
    @Nullable
    private final Long assuredReplicationTimeoutMillis;
    @Nullable
    private final Long intermediateResponsesReturned;
    @Nullable
    private final ResultCode resultCode;
    @NotNull
    private final Set<String> indexesWithKeysAccessedExceedingEntryLimit;
    @NotNull
    private final Set<String> indexesWithKeysAccessedNearEntryLimit;
    @NotNull
    private final Set<String> missingPrivileges;
    @NotNull
    private final Set<String> preAuthorizationUsedPrivileges;
    @NotNull
    private final Set<String> responseControlOIDs;
    @NotNull
    private final Set<String> usedPrivileges;
    @Nullable
    private final String additionalInformation;
    @Nullable
    private final String alternateAuthorizationDN;
    @Nullable
    private final String diagnosticMessage;
    @Nullable
    private final String intermediateClientResponseControl;
    @Nullable
    private final String matchedDN;
    @Nullable
    private final String replicationChangeID;

    TextFormattedResultAccessLogMessageHelper(@NotNull TextFormattedRequestAccessLogMessage logMessage) {
        this.diagnosticMessage = logMessage.getString(TextFormattedAccessLogFields.DIAGNOSTIC_MESSAGE);
        this.additionalInformation = logMessage.getString(TextFormattedAccessLogFields.ADDITIONAL_INFO);
        this.matchedDN = logMessage.getString(TextFormattedAccessLogFields.MATCHED_DN);
        this.processingTimeMillis = logMessage.getDoubleNoThrow(TextFormattedAccessLogFields.PROCESSING_TIME_MILLIS);
        this.workQueueWaitTimeMillis = logMessage.getDoubleNoThrow(TextFormattedAccessLogFields.WORK_QUEUE_WAIT_TIME_MILLIS);
        this.responseControlOIDs = logMessage.getCommaDelimitedStringSet(TextFormattedAccessLogFields.RESPONSE_CONTROL_OIDS);
        this.intermediateResponsesReturned = logMessage.getLongNoThrow(TextFormattedAccessLogFields.INTERMEDIATE_RESPONSES_RETURNED);
        this.serversAccessed = logMessage.getCommaDelimitedStringList(TextFormattedAccessLogFields.SERVERS_ACCESSED);
        this.uncachedDataAccessed = logMessage.getBooleanNoThrow(TextFormattedAccessLogFields.UNCACHED_DATA_ACCESSED);
        this.usedPrivileges = logMessage.getCommaDelimitedStringSet(TextFormattedAccessLogFields.USED_PRIVILEGES);
        this.preAuthorizationUsedPrivileges = logMessage.getCommaDelimitedStringSet(TextFormattedAccessLogFields.PRE_AUTHORIZATION_USED_PRIVILEGES);
        this.missingPrivileges = logMessage.getCommaDelimitedStringSet(TextFormattedAccessLogFields.MISSING_PRIVILEGES);
        this.intermediateClientResponseControl = logMessage.getString(TextFormattedAccessLogFields.INTERMEDIATE_CLIENT_RESULT);
        this.alternateAuthorizationDN = logMessage.getString(TextFormattedAccessLogFields.AUTHORIZATION_DN);
        this.replicationChangeID = logMessage.getString(TextFormattedAccessLogFields.REPLICATION_CHANGE_ID);
        this.indexesWithKeysAccessedNearEntryLimit = logMessage.getCommaDelimitedStringSet(TextFormattedAccessLogFields.INDEXES_WITH_KEYS_ACCESSED_NEAR_ENTRY_LIMIT);
        this.indexesWithKeysAccessedExceedingEntryLimit = logMessage.getCommaDelimitedStringSet(TextFormattedAccessLogFields.INDEXES_WITH_KEYS_ACCESSED_EXCEEDING_ENTRY_LIMIT);
        this.referralURLs = TextFormattedResultAccessLogMessageHelper.parseReferralURLs(logMessage);
        Integer resultCodeInt = logMessage.getIntegerNoThrow(TextFormattedAccessLogFields.RESULT_CODE_VALUE);
        this.resultCode = resultCodeInt == null ? null : ResultCode.valueOf(resultCodeInt);
        this.assuredReplicationTimeoutMillis = logMessage.getLongNoThrow(TextFormattedAccessLogFields.ASSURANCE_TIMEOUT_MILLIS);
        this.responseDelayedByAssurance = logMessage.getBooleanNoThrow(TextFormattedAccessLogFields.RESPONSE_DELAYED_BY_ASSURANCE);
        String localLevelString = logMessage.getString(TextFormattedAccessLogFields.LOCAL_ASSURANCE_LEVEL);
        this.assuredReplicationLocalLevel = localLevelString == null ? null : AssuredReplicationLocalLevel.forName(localLevelString);
        String remoteLevelString = logMessage.getString(TextFormattedAccessLogFields.REMOTE_ASSURANCE_LEVEL);
        this.assuredReplicationRemoteLevel = remoteLevelString == null ? null : AssuredReplicationRemoteLevel.forName(remoteLevelString);
    }

    @NotNull
    static List<String> parseReferralURLs(@NotNull TextFormattedRequestAccessLogMessage logMessage) {
        String urlsStr = logMessage.getString(TextFormattedAccessLogFields.REFERRAL_URLS);
        if (urlsStr == null || urlsStr.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> urlList = new ArrayList<String>();
        int currentURLStartPos = 0;
        while (true) {
            int nextLDAPURLStartPos = urlsStr.indexOf(",ldap://", currentURLStartPos + 1);
            int nextLDAPSURLStartPos = urlsStr.indexOf(",ldaps://", currentURLStartPos + 1);
            if (nextLDAPURLStartPos > 0) {
                if (nextLDAPSURLStartPos > 0 && nextLDAPSURLStartPos < nextLDAPURLStartPos) {
                    urlList.add(urlsStr.substring(currentURLStartPos, nextLDAPSURLStartPos));
                    currentURLStartPos = nextLDAPSURLStartPos + 1;
                    continue;
                }
                urlList.add(urlsStr.substring(currentURLStartPos, nextLDAPURLStartPos));
                currentURLStartPos = nextLDAPURLStartPos + 1;
                continue;
            }
            if (nextLDAPSURLStartPos <= 0) break;
            urlList.add(urlsStr.substring(currentURLStartPos, nextLDAPSURLStartPos));
            currentURLStartPos = nextLDAPSURLStartPos + 1;
        }
        urlList.add(urlsStr.substring(currentURLStartPos));
        return Collections.unmodifiableList(urlList);
    }

    @Nullable
    ResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @Nullable
    String getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Nullable
    String getMatchedDN() {
        return this.matchedDN;
    }

    @NotNull
    List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Nullable
    Double getProcessingTimeMillis() {
        return this.processingTimeMillis;
    }

    @Nullable
    Double getWorkQueueWaitTimeMillis() {
        return this.workQueueWaitTimeMillis;
    }

    @NotNull
    Set<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }

    @Nullable
    Long getIntermediateResponsesReturned() {
        return this.intermediateResponsesReturned;
    }

    @NotNull
    List<String> getServersAccessed() {
        return this.serversAccessed;
    }

    @Nullable
    Boolean getUncachedDataAccessed() {
        return this.uncachedDataAccessed;
    }

    @NotNull
    Set<String> getUsedPrivileges() {
        return this.usedPrivileges;
    }

    @NotNull
    Set<String> getPreAuthorizationUsedPrivileges() {
        return this.preAuthorizationUsedPrivileges;
    }

    @NotNull
    Set<String> getMissingPrivileges() {
        return this.missingPrivileges;
    }

    @Nullable
    String getAlternateAuthorizationDN() {
        return this.alternateAuthorizationDN;
    }

    @Nullable
    String getReplicationChangeID() {
        return this.replicationChangeID;
    }

    @Nullable
    AssuredReplicationLocalLevel getAssuredReplicationLocalLevel() {
        return this.assuredReplicationLocalLevel;
    }

    @Nullable
    AssuredReplicationRemoteLevel getAssuredReplicationRemoteLevel() {
        return this.assuredReplicationRemoteLevel;
    }

    @Nullable
    Long getAssuredReplicationTimeoutMillis() {
        return this.assuredReplicationTimeoutMillis;
    }

    @Nullable
    Boolean getResponseDelayedByAssurance() {
        return this.responseDelayedByAssurance;
    }

    @NotNull
    Set<String> getIndexesWithKeysAccessedNearEntryLimit() {
        return this.indexesWithKeysAccessedNearEntryLimit;
    }

    @NotNull
    Set<String> getIndexesWithKeysAccessedExceedingEntryLimit() {
        return this.indexesWithKeysAccessedExceedingEntryLimit;
    }

    @Nullable
    String getIntermediateClientResponseControl() {
        return this.intermediateClientResponseControl;
    }
}

