/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.filtering;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventWithState;
import org.apache.james.eventsourcing.ReactiveSubscriber;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.api.filtering.Rules;
import org.apache.james.jmap.api.filtering.Version;
import org.apache.james.jmap.api.filtering.impl.EventSourcingFilteringManagement;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregate;
import org.apache.james.jmap.postgres.filtering.PostgresFilteringProjectionDAO;
import org.reactivestreams.Publisher;

public class PostgresFilteringProjection
implements EventSourcingFilteringManagement.ReadProjection,
ReactiveSubscriber {
    private final PostgresFilteringProjectionDAO postgresFilteringProjectionDAO;

    @Inject
    public PostgresFilteringProjection(PostgresFilteringProjectionDAO postgresFilteringProjectionDAO) {
        this.postgresFilteringProjectionDAO = postgresFilteringProjectionDAO;
    }

    public Publisher<Void> handleReactive(EventWithState eventWithState) {
        Event event = eventWithState.event();
        FilteringAggregate.FilterState state = (FilteringAggregate.FilterState)eventWithState.state().get();
        return this.postgresFilteringProjectionDAO.upsert(event.getAggregateId(), event.eventId(), (ImmutableList<Rule>)state.getRules());
    }

    public Publisher<Rules> listRulesForUser(Username username) {
        return this.postgresFilteringProjectionDAO.listRulesForUser(username);
    }

    public Publisher<Version> getLatestVersion(Username username) {
        return this.postgresFilteringProjectionDAO.getVersion(username);
    }

    public Optional<ReactiveSubscriber> subscriber() {
        return Optional.of(this);
    }
}

