/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.james.mailbox.model.Content;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class HeaderAndBodyByteContent
implements Content {
    private final byte[] headers;
    private final byte[] body;
    private final long size;

    public HeaderAndBodyByteContent(byte[] headers, byte[] body) {
        this.headers = headers;
        this.body = body;
        this.size = (long)headers.length + (long)body.length;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public InputStream getInputStream() {
        return new SequenceInputStream(new ByteArrayInputStream(this.headers), new ByteArrayInputStream(this.body));
    }

    @Override
    public Optional<byte[][]> asBytesSequence() {
        byte[][] answer = new byte[][]{this.headers, this.body};
        return Optional.of(answer);
    }

    @Override
    public Publisher<ByteBuffer> reactiveBytes() {
        return Flux.concat((Publisher[])new Publisher[]{Flux.just((Object)this.headers).map(ByteBuffer::wrap), Flux.just((Object)this.body).map(ByteBuffer::wrap)});
    }
}

