/*
 * Decompiled with CFR 0.152.
 */
package spark.servlet;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

final class FilterTools {
    private static final String SLASH_WILDCARD = "/*";
    private static final String SLASH = "/";
    private static final String FILTER_MAPPING_PARAM = "filterMappingUrlPattern";

    private FilterTools() {
    }

    static String getRelativePath(HttpServletRequest request, String filterPath) {
        Object path = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (((String)(path = ((String)path).substring(contextPath.length()))).length() > 0) {
            path = ((String)path).substring(1);
        }
        if (!((String)path).startsWith(filterPath) && filterPath.equals((String)path + SLASH)) {
            path = (String)path + SLASH;
        }
        if (((String)path).startsWith(filterPath)) {
            path = ((String)path).substring(filterPath.length());
        }
        if (!((String)path).startsWith(SLASH)) {
            path = SLASH + (String)path;
        }
        try {
            path = URLDecoder.decode((String)path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return path;
    }

    static String getFilterPath(FilterConfig config) {
        String result = config.getInitParameter(FILTER_MAPPING_PARAM);
        if (result == null || result.equals(SLASH_WILDCARD)) {
            return "";
        }
        if (!result.startsWith(SLASH) || !result.endsWith(SLASH_WILDCARD)) {
            throw new RuntimeException("The filterMappingUrlPattern must start with \"/\" and end with \"/*\". It's: " + result);
        }
        return result.substring(1, result.length() - 1);
    }
}

