/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.Iterator;

abstract class MultiIteratorBase<E, I extends Iterator<E>>
implements Iterator<E> {
    private final I[] iterators;
    private int index = -1;

    MultiIteratorBase(I[] iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            I currentIterator;
            if (this.index != -1 && (currentIterator = this.get(this.index)).hasNext()) {
                return true;
            }
            int next = this.index + 1;
            if (next >= this.iterators.length) break;
            this.moveTo(next);
        }
        return false;
    }

    @Override
    public E next() {
        while (true) {
            I currentIterator;
            if (this.index != -1 && (currentIterator = this.get(this.index)).hasNext()) {
                return currentIterator.next();
            }
            int next = this.index + 1;
            if (next >= this.iterators.length) break;
            this.moveTo(next);
        }
        return null;
    }

    protected void moveTo(int index) {
        this.index = index;
    }

    protected I get(int index) {
        return this.iterators[index];
    }
}

