/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class CreateSequenceNode
extends DDLStatementNode {
    private TableName _sequenceName;
    private DataTypeDescriptor _dataType;
    private Long _initialValue;
    private Long _stepValue;
    private Long _maxValue;
    private Long _minValue;
    private boolean _cycle;
    public static final int SEQUENCE_ELEMENT_COUNT = 1;

    CreateSequenceNode(TableName tableName, DataTypeDescriptor dataTypeDescriptor, Long l, Long l2, Long l3, Long l4, boolean bl, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this._sequenceName = tableName;
        this._dataType = dataTypeDescriptor != null ? dataTypeDescriptor : DataTypeDescriptor.INTEGER;
        Long l5 = this._stepValue = l2 != null ? l2 : Long.valueOf(1L);
        if (this._dataType.getTypeId().equals(TypeId.SMALLINT_ID)) {
            this._minValue = l4 != null ? l4 : Long.valueOf(-32768L);
            this._maxValue = l3 != null ? l3 : Long.valueOf(32767L);
        } else if (this._dataType.getTypeId().equals(TypeId.INTEGER_ID)) {
            this._minValue = l4 != null ? l4 : Long.valueOf(Integer.MIN_VALUE);
            this._maxValue = l3 != null ? l3 : Long.valueOf(Integer.MAX_VALUE);
        } else {
            this._minValue = l4 != null ? l4 : Long.MIN_VALUE;
            this._maxValue = l3 != null ? l3 : Long.MAX_VALUE;
        }
        this._initialValue = l != null ? l : (this._stepValue > 0L ? this._minValue : this._maxValue);
        this._cycle = bl;
        this.implicitCreateSchema = true;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public void bindStatement() throws StandardException {
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        if (this._sequenceName.getSchemaName() == null) {
            this._sequenceName.setSchemaName(schemaDescriptor.getSchemaName());
        }
        if (this._dataType.getTypeId().equals(TypeId.SMALLINT_ID)) {
            if (this._minValue < -32768L || this._minValue >= 32767L) {
                throw StandardException.newException((String)"42XAE", (Object[])new Object[]{"MINVALUE", "SMALLINT", "-32768", "32767"});
            }
            if (this._maxValue <= -32768L || this._maxValue > 32767L) {
                throw StandardException.newException((String)"42XAE", (Object[])new Object[]{"MAXVALUE", "SMALLINT", "-32768", "32767"});
            }
        } else if (this._dataType.getTypeId().equals(TypeId.INTEGER_ID)) {
            if (this._minValue < Integer.MIN_VALUE || this._minValue >= Integer.MAX_VALUE) {
                throw StandardException.newException((String)"42XAE", (Object[])new Object[]{"MINVALUE", "INTEGER", "-2147483648", "2147483647"});
            }
            if (this._maxValue <= Integer.MIN_VALUE || this._maxValue > Integer.MAX_VALUE) {
                throw StandardException.newException((String)"42XAE", (Object[])new Object[]{"MAXVALUE", "INTEGER", "-2147483648", "2147483647"});
            }
        } else {
            if (this._minValue < Long.MIN_VALUE || this._minValue >= Long.MAX_VALUE) {
                throw StandardException.newException((String)"42XAE", (Object[])new Object[]{"MINVALUE", "BIGINT", "-9223372036854775808", "9223372036854775807"});
            }
            if (this._maxValue <= Long.MIN_VALUE || this._maxValue > Long.MAX_VALUE) {
                throw StandardException.newException((String)"42XAE", (Object[])new Object[]{"MAXVALUE", "BIGINT", "-9223372036854775808", "9223372036854775807"});
            }
        }
        if (this._minValue >= this._maxValue) {
            throw StandardException.newException((String)"42XAF", (Object[])new Object[]{this._minValue.toString(), this._maxValue.toString()});
        }
        if (this._initialValue < this._minValue || this._initialValue > this._maxValue) {
            throw StandardException.newException((String)"42XAG", (Object[])new Object[]{this._initialValue.toString(), this._minValue.toString(), this._maxValue.toString()});
        }
        if (this._stepValue == 0L) {
            throw StandardException.newException((String)"42XAC", (Object[])new Object[0]);
        }
    }

    @Override
    public String statementToString() {
        return "CREATE SEQUENCE";
    }

    @Override
    public ConstantAction makeConstantAction() {
        return this.getGenericConstantActionFactory().getCreateSequenceConstantAction(this._sequenceName, this._dataType, this._initialValue, this._stepValue, this._maxValue, this._minValue, this._cycle);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this._sequenceName != null) {
            this._sequenceName = (TableName)this._sequenceName.accept(visitor);
        }
    }
}

