/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyErrorType;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyWarningType;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordPolicyResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String PASSWORD_POLICY_RESPONSE_OID = "1.3.6.1.4.1.42.2.27.8.5.1";
    private static final byte TYPE_WARNING = -96;
    private static final byte TYPE_ERROR = -127;
    private static final byte TYPE_TIME_BEFORE_EXPIRATION = -128;
    private static final byte TYPE_GRACE_LOGINS_REMAINING = -127;
    @NotNull
    private static final String JSON_FIELD_ERROR_TYPE = "error-type";
    @NotNull
    private static final String JSON_FIELD_GRACE_LOGINS_REMAINING = "grace-logins-remaining";
    @NotNull
    private static final String JSON_FIELD_SECONDS_UNTIL_EXPIRATION = "seconds-until-expiration";
    @NotNull
    private static final String JSON_FIELD_WARNING = "warning";
    @NotNull
    private static final String JSON_ERROR_TYPE_ACCOUNT_LOCKED = "account-locked";
    @NotNull
    private static final String JSON_ERROR_TYPE_CHANGE_AFTER_RESET = "change-after-reset";
    @NotNull
    private static final String JSON_ERROR_TYPE_INSUFFICIENT_PASSWORD_QUALITY = "insufficient-password-quality";
    @NotNull
    private static final String JSON_ERROR_TYPE_MUST_SUPPLY_OLD_PASSWORD = "must-supply-old-password";
    @NotNull
    private static final String JSON_ERROR_TYPE_PASSWORD_EXPIRED = "password-expired";
    @NotNull
    private static final String JSON_ERROR_TYPE_PASSWORD_IN_HISTORY = "password-in-history";
    @NotNull
    private static final String JSON_ERROR_TYPE_PASSWORD_TOO_SHORT = "password-too-short";
    @NotNull
    private static final String JSON_ERROR_TYPE_PASSWORD_TOO_YOUNG = "password-too-young";
    @NotNull
    private static final String JSON_ERROR_TYPE_PASSWORD_MOD_NOT_ALLOWED = "password-mod-not-allowed";
    private static final long serialVersionUID = 1835830253434331833L;
    private final int warningValue;
    @Nullable
    private final PasswordPolicyErrorType errorType;
    @Nullable
    private final PasswordPolicyWarningType warningType;

    PasswordPolicyResponseControl() {
        this.warningType = null;
        this.errorType = null;
        this.warningValue = -1;
    }

    public PasswordPolicyResponseControl(@Nullable PasswordPolicyWarningType warningType, int warningValue, @Nullable PasswordPolicyErrorType errorType) {
        this(warningType, warningValue, errorType, false);
    }

    public PasswordPolicyResponseControl(@Nullable PasswordPolicyWarningType warningType, int warningValue, @Nullable PasswordPolicyErrorType errorType, boolean isCritical) {
        super(PASSWORD_POLICY_RESPONSE_OID, isCritical, PasswordPolicyResponseControl.encodeValue(warningType, warningValue, errorType));
        this.warningType = warningType;
        this.errorType = errorType;
        this.warningValue = warningType == null ? -1 : warningValue;
    }

    /*
     * Unable to fully structure code
     */
    public PasswordPolicyResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_NO_VALUE.get());
        }
        try {
            valueElement = ASN1Element.decode(value.getValue());
            valueSequence = ASN1Sequence.decodeAsSequence(valueElement);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_VALUE_NOT_SEQUENCE.get(new Object[]{ae}), ae);
        }
        valueElements = valueSequence.elements();
        if (valueElements.length > 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_INVALID_ELEMENT_COUNT.get(new Object[]{valueElements.length}));
        }
        wv = -1;
        et = null;
        wt = null;
        block14: for (ASN1Element e : valueElements) {
            switch (e.getType()) {
                case -96: {
                    if (wt == null) {
                        try {
                            warningElement = ASN1Element.decode(e.getValue());
                            wv = ASN1Integer.decodeAsInteger(warningElement).intValue();
                            switch (warningElement.getType()) {
                                case -128: {
                                    wt = PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION;
                                    ** break;
                                }
                                case -127: {
                                    wt = PasswordPolicyWarningType.GRACE_LOGINS_REMAINING;
                                    ** break;
                                }
                            }
                            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_INVALID_WARNING_TYPE.get(new Object[]{StaticUtils.toHex(warningElement.getType())}));
lbl32:
                            // 2 sources

                            continue block14;
                        }
                        catch (ASN1Exception ae) {
                            Debug.debugException(ae);
                            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_CANNOT_DECODE_WARNING.get(new Object[]{ae}), ae);
                        }
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_MULTIPLE_WARNING.get());
                }
                case -127: {
                    if (et == null) {
                        try {
                            errorElement = ASN1Enumerated.decodeAsEnumerated(e);
                            et = PasswordPolicyErrorType.valueOf(errorElement.intValue());
                            if (et != null) continue block14;
                            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_INVALID_ERROR_TYPE.get(new Object[]{errorElement.intValue()}));
                        }
                        catch (ASN1Exception ae) {
                            Debug.debugException(ae);
                            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_CANNOT_DECODE_ERROR.get(new Object[]{ae}), ae);
                        }
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_MULTIPLE_ERROR.get());
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_INVALID_TYPE.get(new Object[]{StaticUtils.toHex(e.getType())}));
                }
            }
        }
        this.warningType = wt;
        this.warningValue = wv;
        this.errorType = et;
    }

    @Override
    @NotNull
    public PasswordPolicyResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new PasswordPolicyResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static PasswordPolicyResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(PASSWORD_POLICY_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof PasswordPolicyResponseControl) {
            return (PasswordPolicyResponseControl)c;
        }
        return new PasswordPolicyResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable PasswordPolicyWarningType warningType, int warningValue, @Nullable PasswordPolicyErrorType errorType) {
        ArrayList<ASN1Element> valueElements = new ArrayList<ASN1Element>(2);
        if (warningType != null) {
            switch (warningType) {
                case TIME_BEFORE_EXPIRATION: {
                    valueElements.add(new ASN1Element(-96, new ASN1Integer(-128, warningValue).encode()));
                    break;
                }
                case GRACE_LOGINS_REMAINING: {
                    valueElements.add(new ASN1Element(-96, new ASN1Integer(-127, warningValue).encode()));
                }
            }
        }
        if (errorType != null) {
            valueElements.add(new ASN1Enumerated(-127, errorType.intValue()));
        }
        return new ASN1OctetString(new ASN1Sequence(valueElements).encode());
    }

    @Nullable
    public PasswordPolicyWarningType getWarningType() {
        return this.warningType;
    }

    public int getWarningValue() {
        return this.warningValue;
    }

    @Nullable
    public PasswordPolicyErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PW_POLICY_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        if (this.warningType != null) {
            switch (this.warningType) {
                case TIME_BEFORE_EXPIRATION: {
                    valueFields.put(JSON_FIELD_WARNING, new JSONObject(new JSONField(JSON_FIELD_SECONDS_UNTIL_EXPIRATION, this.warningValue)));
                    break;
                }
                case GRACE_LOGINS_REMAINING: {
                    valueFields.put(JSON_FIELD_WARNING, new JSONObject(new JSONField(JSON_FIELD_GRACE_LOGINS_REMAINING, this.warningValue)));
                }
            }
        }
        if (this.errorType != null) {
            switch (this.errorType) {
                case PASSWORD_EXPIRED: {
                    valueFields.put(JSON_FIELD_ERROR_TYPE, new JSONString(JSON_ERROR_TYPE_PASSWORD_EXPIRED));
                    break;
                }
                case ACCOUNT_LOCKED: {
                    valueFields.put(JSON_FIELD_ERROR_TYPE, new JSONString(JSON_ERROR_TYPE_ACCOUNT_LOCKED));
                    break;
                }
                case CHANGE_AFTER_RESET: {
                    valueFields.put(JSON_FIELD_ERROR_TYPE, new JSONString(JSON_ERROR_TYPE_CHANGE_AFTER_RESET));
                    break;
                }
                case PASSWORD_MOD_NOT_ALLOWED: {
                    valueFields.put(JSON_FIELD_ERROR_TYPE, new JSONString(JSON_ERROR_TYPE_PASSWORD_MOD_NOT_ALLOWED));
                    break;
                }
                case MUST_SUPPLY_OLD_PASSWORD: {
                    valueFields.put(JSON_FIELD_ERROR_TYPE, new JSONString(JSON_ERROR_TYPE_MUST_SUPPLY_OLD_PASSWORD));
                    break;
                }
                case INSUFFICIENT_PASSWORD_QUALITY: {
                    valueFields.put(JSON_FIELD_ERROR_TYPE, new JSONString(JSON_ERROR_TYPE_INSUFFICIENT_PASSWORD_QUALITY));
                    break;
                }
                case PASSWORD_TOO_SHORT: {
                    valueFields.put(JSON_FIELD_ERROR_TYPE, new JSONString(JSON_ERROR_TYPE_PASSWORD_TOO_SHORT));
                    break;
                }
                case PASSWORD_TOO_YOUNG: {
                    valueFields.put(JSON_FIELD_ERROR_TYPE, new JSONString(JSON_ERROR_TYPE_PASSWORD_TOO_YOUNG));
                    break;
                }
                case PASSWORD_IN_HISTORY: {
                    valueFields.put(JSON_FIELD_ERROR_TYPE, new JSONString(JSON_ERROR_TYPE_PASSWORD_IN_HISTORY));
                }
            }
        }
        return new JSONObject(new JSONField("oid", PASSWORD_POLICY_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_PW_POLICY_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static PasswordPolicyResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        PasswordPolicyErrorType errorType;
        List<String> unrecognizedFields;
        int warningValue;
        PasswordPolicyWarningType warningType;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new PasswordPolicyResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        JSONObject warningObject = valueObject.getFieldAsObject(JSON_FIELD_WARNING);
        if (warningObject == null) {
            warningType = null;
            warningValue = -1;
        } else {
            Integer secondsUntilExpiration = warningObject.getFieldAsInteger(JSON_FIELD_SECONDS_UNTIL_EXPIRATION);
            Integer graceLoginsRemaining = warningObject.getFieldAsInteger(JSON_FIELD_GRACE_LOGINS_REMAINING);
            if (secondsUntilExpiration == null) {
                if (graceLoginsRemaining == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_JSON_NO_RECOGNIZED_WARNING_TYPE.get(controlObject.toSingleLineString(), JSON_FIELD_WARNING));
                }
                warningType = PasswordPolicyWarningType.GRACE_LOGINS_REMAINING;
                warningValue = graceLoginsRemaining;
            } else if (graceLoginsRemaining == null) {
                warningType = PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION;
                warningValue = secondsUntilExpiration;
            } else {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_JSON_MULTIPLE_WARNING_TYPES.get(controlObject.toSingleLineString(), JSON_FIELD_WARNING));
            }
            if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(warningObject, JSON_FIELD_SECONDS_UNTIL_EXPIRATION, JSON_FIELD_GRACE_LOGINS_REMAINING)).isEmpty()) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_JSON_UNRECOGNIZED_WARNING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_WARNING, unrecognizedFields.get(0)));
            }
        }
        String errorTypeString = valueObject.getFieldAsString(JSON_FIELD_ERROR_TYPE);
        if (errorTypeString == null) {
            errorType = null;
        } else {
            switch (errorTypeString) {
                case "password-expired": {
                    errorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                    break;
                }
                case "account-locked": {
                    errorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                    break;
                }
                case "change-after-reset": {
                    errorType = PasswordPolicyErrorType.CHANGE_AFTER_RESET;
                    break;
                }
                case "password-mod-not-allowed": {
                    errorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
                    break;
                }
                case "must-supply-old-password": {
                    errorType = PasswordPolicyErrorType.MUST_SUPPLY_OLD_PASSWORD;
                    break;
                }
                case "insufficient-password-quality": {
                    errorType = PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY;
                    break;
                }
                case "password-too-short": {
                    errorType = PasswordPolicyErrorType.PASSWORD_TOO_SHORT;
                    break;
                }
                case "password-too-young": {
                    errorType = PasswordPolicyErrorType.PASSWORD_TOO_YOUNG;
                    break;
                }
                case "password-in-history": {
                    errorType = PasswordPolicyErrorType.PASSWORD_IN_HISTORY;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_JSON_UNRECOGNIZED_ERROR_TYPE.get(controlObject.toSingleLineString(), JSON_FIELD_ERROR_TYPE, errorTypeString));
                }
            }
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_WARNING, JSON_FIELD_ERROR_TYPE)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PWP_RESPONSE_JSON_UNRECOGNIZED_VALUE_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new PasswordPolicyResponseControl(warningType, warningValue, errorType, jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PasswordPolicyResponseControl(");
        boolean elementAdded = false;
        if (this.warningType != null) {
            buffer.append("warningType='");
            buffer.append(this.warningType.getName());
            buffer.append("', warningValue=");
            buffer.append(this.warningValue);
            elementAdded = true;
        }
        if (this.errorType != null) {
            if (elementAdded) {
                buffer.append(", ");
            }
            buffer.append("errorType='");
            buffer.append(this.errorType.getName());
            buffer.append('\'');
            elementAdded = true;
        }
        if (elementAdded) {
            buffer.append(", ");
        }
        buffer.append("isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

