/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class CancelRequest
implements FrontendMessage {
    private static final int REQUEST_CODE = 80877102;
    private final int processId;
    private final int secretKey;

    public CancelRequest(int processId, int secretKey) {
        this.processId = processId;
        this.secretKey = secretKey;
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer(16);
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeInt(out, 80877102);
            FrontendMessageUtils.writeInt(out, this.processId);
            FrontendMessageUtils.writeInt(out, this.secretKey);
            return FrontendMessageUtils.writeSize(out, 0);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelRequest that = (CancelRequest)o;
        return this.processId == that.processId && this.secretKey == that.secretKey;
    }

    public int hashCode() {
        return Objects.hash(this.processId, this.secretKey);
    }

    public String toString() {
        return "CancelRequest{processId=" + this.processId + ", secretKey=" + this.secretKey + '}';
    }
}

