/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message.request;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DayMonthYear {
    private final int day;
    private final int month;
    private final int year;

    public DayMonthYear(int day, int month, int year) {
        this.day = day;
        this.month = month;
        this.year = year;
    }

    public final int getDay() {
        return this.day;
    }

    public final int getMonth() {
        return this.month;
    }

    public final Date toDate() {
        Calendar cal = this.getGMT();
        cal.set(this.getYear(), this.getMonth() - 1, this.getDay());
        return cal.getTime();
    }

    private Calendar getGMT() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.UK);
    }

    public final int getYear() {
        return this.year;
    }

    public String toString() {
        return this.day + "-" + this.month + "-" + this.year;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.day;
        result = 31 * result + this.month;
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DayMonthYear other = (DayMonthYear)obj;
        if (this.day != other.day) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        return this.year == other.year;
    }
}

