/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.Optional;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailetPipelineLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailetPipelineLogging.class);

    public static void logBeginOfMailetProcess(Mailet mailet, Mail mail) {
        LOGGER.debug("Mail: {} Entering mailet: {}", (Object)mail.getState(), (Object)MailetPipelineLogging.getMailetInfo(mailet));
    }

    public static void logEndOfMailetProcess(Mailet mailet, Mail mail) {
        LOGGER.debug("Mail: {} End of mailet: {}", (Object)mail.getState(), (Object)MailetPipelineLogging.getMailetInfo(mailet));
    }

    @VisibleForTesting
    static String getMailetInfo(Mailet mailet) {
        return Optional.ofNullable(Strings.emptyToNull(mailet.getMailetInfo())).orElse(mailet.getClass().getSimpleName());
    }
}

