/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RcptCmdHandler
extends AbstractHookableCmdHandler<RcptHook>
implements CommandHandler<SMTPSession> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RcptCmdHandler.class);
    public static final ProtocolSession.AttachmentKey<MailAddress> CURRENT_RECIPIENT = ProtocolSession.AttachmentKey.of((String)"CURRENT_RECIPIENT", MailAddress.class);
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"RCPT");
    private static final Response MAIL_NEEDED = new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " Need MAIL before RCPT").immutable();
    private static final Response SYNTAX_ERROR_ARGS = new SMTPResponse("501", DSNStatus.getStatus(5, "5.2") + " Usage: RCPT TO:<recipient>").immutable();
    private static final Response SYNTAX_ERROR_DELIVERY = new SMTPResponse("501", DSNStatus.getStatus(5, "5.2") + " Syntax error in parameters or arguments").immutable();
    private static final Response SYNTAX_ERROR_ADDRESS = new SMTPResponse("553", DSNStatus.getStatus(5, "1.3") + " Syntax error in recipient address").immutable();

    @Inject
    public RcptCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
    }

    @Override
    protected Response doCoreCmd(SMTPSession session, String command, String parameters) {
        List rcptColl = session.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction).orElseGet(ArrayList::new);
        MailAddress recipientAddress = session.getAttachment(CURRENT_RECIPIENT, ProtocolSession.State.Transaction).orElse(MailAddress.nullSender());
        rcptColl.add(recipientAddress);
        session.setAttachment(SMTPSession.RCPT_LIST, rcptColl, ProtocolSession.State.Transaction);
        StringBuilder response = new StringBuilder();
        response.append(DSNStatus.getStatus(2, "1.5")).append(" Recipient <").append(recipientAddress).append("> OK");
        return new SMTPResponse("250", response);
    }

    @Override
    protected Response doFilterChecks(SMTPSession session, String command, String argument) {
        Object recipient = null;
        if (argument != null && argument.indexOf(":") > 0) {
            int colonIndex = argument.indexOf(":");
            recipient = argument.substring(colonIndex + 1);
            argument = argument.substring(0, colonIndex);
        }
        if (!session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).isPresent()) {
            return MAIL_NEEDED;
        }
        if (argument == null || !argument.toUpperCase(Locale.US).equals("TO") || recipient == null) {
            return SYNTAX_ERROR_ARGS;
        }
        recipient = ((String)recipient).trim();
        int lastChar = ((String)recipient).lastIndexOf(62);
        String rcptOptionString = null;
        if (lastChar > 0 && ((String)recipient).length() > lastChar + 2 && ((String)recipient).charAt(lastChar + 1) == ' ') {
            rcptOptionString = ((String)recipient).substring(lastChar + 2);
            recipient = ((String)recipient).substring(0, lastChar + 1);
        }
        if (!(!session.getConfiguration().useAddressBracketsEnforcement() || ((String)recipient).startsWith("<") && ((String)recipient).endsWith(">"))) {
            LOGGER.info("Error parsing recipient address: Address did not start and end with < >{}", (Object)this.getContext(session, null, (String)recipient));
            return SYNTAX_ERROR_DELIVERY;
        }
        MailAddress recipientAddress = null;
        if (session.getConfiguration().useAddressBracketsEnforcement() || ((String)recipient).startsWith("<") && ((String)recipient).endsWith(">")) {
            recipient = ((String)recipient).substring(1, ((String)recipient).length() - 1);
        }
        if (!((String)recipient).contains("@")) {
            recipient = (String)recipient + "@" + this.getDefaultDomain();
        }
        try {
            recipientAddress = new MailAddress((String)recipient);
        }
        catch (Exception pe) {
            LOGGER.info("Error parsing recipient address{}", (Object)this.getContext(session, recipientAddress, (String)recipient), (Object)pe);
            return SYNTAX_ERROR_ADDRESS;
        }
        if (rcptOptionString != null) {
            StringTokenizer optionTokenizer = new StringTokenizer(rcptOptionString, " ");
            while (optionTokenizer.hasMoreElements()) {
                String rcptOption = optionTokenizer.nextToken();
                Pair<String, String> parameter = this.parseParameter(rcptOption);
                if (this.supportedParameter((String)parameter.getKey())) continue;
                LOGGER.debug("RCPT command had unrecognized/unexpected option {} with value {}{}", new Object[]{parameter.getKey(), parameter.getValue(), this.getContext(session, recipientAddress, (String)recipient)});
                return new SMTPResponse("504", "Unrecognized or unsupported option: " + (String)parameter.getKey());
            }
            optionTokenizer = null;
        }
        session.setAttachment(CURRENT_RECIPIENT, recipientAddress, ProtocolSession.State.Transaction);
        return null;
    }

    private String getContext(SMTPSession session, MailAddress recipientAddress, String recipient) {
        StringBuilder sb = new StringBuilder(128);
        if (null != recipientAddress) {
            sb.append(" [to:").append(recipientAddress.asString()).append(']');
        } else if (null != recipient) {
            sb.append(" [to:").append(recipient).append(']');
        }
        MaybeSender sender = session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).orElse(MaybeSender.nullSender());
        if (!sender.isNullSender()) {
            sb.append(" [from:").append(sender.asString()).append(']');
        }
        return sb.toString();
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected Class<RcptHook> getHookInterface() {
        return RcptHook.class;
    }

    @Override
    protected HookResult callHook(RcptHook rawHook, SMTPSession session, String parametersString) {
        MaybeSender sender = session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).orElse(MaybeSender.nullSender());
        Map<String, String> parameters = this.parseParameters(parametersString);
        MailAddress rcpt = session.getAttachment(CURRENT_RECIPIENT, ProtocolSession.State.Transaction).orElse(MailAddress.nullSender());
        return rawHook.doRcpt(session, sender, rcpt, parameters);
    }

    private Map<String, String> parseParameters(String rcptOptions) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (String option : Splitter.on((char)' ').split((CharSequence)rcptOptions)) {
            result.put(this.parseParameter(option));
        }
        return result.build();
    }

    private Pair<String, String> parseParameter(String rcptOption) {
        int equalIndex = rcptOption.indexOf(61);
        if (equalIndex > 0) {
            return Pair.of((Object)rcptOption.substring(0, equalIndex).toUpperCase(Locale.US), (Object)rcptOption.substring(equalIndex + 1));
        }
        return Pair.of((Object)rcptOption, (Object)"");
    }

    private boolean supportedParameter(String parameterName) {
        return this.getHooks().stream().anyMatch(rcptHook -> rcptHook.supportedParameters().contains(parameterName));
    }

    protected String getDefaultDomain() {
        return "localhost";
    }
}

